define([
    'jquery',
    'jsn/libs/modal',
    'jsn/visualdesignstyle',
    'jquery.json',
    'jquery.ui'],
    function ($, JSNModal, JSNVisualDesignStyle) {
        var JSNMobilizeStyle = function (params) {
            this.params = params;
            this.lang = params.language;
            this.generateStyle = new JSNVisualDesignStyle(params);
            this.init();
        }
        JSNMobilizeStyle.prototype = {
            init:function () {
                var self = this;
                $(document).click(function () {
                    $(".mobilize-dialog").remove();
                    $(".jsn-element-active").removeClass("jsn-element-active");
                    $(".ui-state-edit").removeClass("ui-state-edit");
                });
                $(".jsn-iconbar a").click(function (e) {
                    var buttons = {}, selfAction = this;
                    buttons[self.lang['JSN_MOBILIZE_SAVE']] = $.proxy(function () {
                        var items = [];
                        $("#jsn-block-container").find("input,select").each(function () {
                            if ($(this).hasClass("jsn-m-radio")) {
                                if ($(this).is(":checked")) {
                                    var item = {};
                                    item.key = $(this).attr("name");
                                    item.value = $(this).val();
                                    items.push(item);
                                }
                            } else {
                                var item = {};
                                item.key = $(this).attr("name");
                                item.value = $(this).val();
                                items.push(item);
                            }
                        });
                        $(selfAction).next("input.jsn-input-style").val($.toJSON(items));
                        self.changeStyle($(selfAction));
                        //  $(this).dialog("close");
                        $("#jsn-block-container").parents(".ui-dialog").remove();
                        //$(selfAction).parents(".jsn-block").removeClass("jsn-edit-state");
                        $(".colorpicker").remove();
                    }, this);
                    buttons[self.lang['JSN_MOBILIZE_CANCEL']] = $.proxy(function () {
                        //  $(this).dialog("close");
                        $("#jsn-block-container").parents(".ui-dialog").remove();
                        //   $(selfAction).parents(".jsn-block").removeClass("jsn-edit-state");
                        $(".colorpicker").remove();
                    }, this);
                    var height = $(window).height();
                    var valueDefault = $(this).parents().find("input[type=hidden]").val() ? $.evalJSON($(this).parents().find("input[type=hidden]").val()) : "";
                    var defaultValue = {};
                    if (valueDefault) {
                        $.each(valueDefault, function () {
                            defaultValue[this.key] = this.value;
                        });
                    }
                    if ($(this).attr("data-action") == "menu") {
                        self.generateStyle.createModalGenerateStyle($(this), self.designStyleMenu(this), defaultValue, buttons, "Style Settings", 750, height * (95 / 100));
                    }
                    if ($(this).attr("data-action") == "module") {
                        self.generateStyle.createModalGenerateStyle($(this), self.designStyleModule(this), defaultValue, buttons, "Style Settings", 750, height * (95 / 100));
                    }
                    if ($(this).attr("data-action") == "logo") {
                        self.generateStyle.createModalGenerateStyle($(this), self.designStyleLogo(this), defaultValue, buttons, "Style Settings", 750, height * (95 / 100));
                    }
                    if ($(this).attr("data-action") == "mainbody") {
                        self.generateStyle.createModalGenerateStyle($(this), self.designStyleMainBody(this), defaultValue, buttons, "Style Settings", 750, height * (95 / 100));
                    }
                    if ($(this).attr("data-action") == "switcher") {
                        self.generateStyle.createModalGenerateStyle($(this), self.designStyleSwitcher(this), defaultValue, buttons, "Style Settings", 750, height * (95 / 100));
                    }
                    $("#jsn-block-container").find("input.jsn-borderThickness,input.jsn-input-number,input.jsn-input-number,input.jsn-roundedCornerRadius").each(function () {
                        $(this).keypress(function (e) {
                            if (e.which == 45) {
                                var valueInput = $(this).val();
                                valueInput = valueInput.replace(new RegExp('-', 'g'), '');
                                $(this).val('-' + valueInput);
                                return false;
                            }
                            if (e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {
                                return false;
                            }
                        });
                    });
                    e.stopPropagation();
                });
                self.getBackgroundIconColor();
            },
            hexToRgb:function (h) {
                var r = parseInt((this.cutHex(h)).substring(0, 2), 16), g = ((this.cutHex(h)).substring(2, 4), 16), b = parseInt((this.cutHex(h)).substring(4, 6), 16)
                return r + '' + b + '' + b;
            },
            convertHextToRgba:function (hex, opacity) {
                hex = hex.replace('#', '');
                r = parseInt(hex.substring(0, 2), 16);
                g = parseInt(hex.substring(2, 4), 16);
                b = parseInt(hex.substring(4, 6), 16);
                var result = 'rgba(' + r + ',' + g + ',' + b + ',' + opacity / 100 + ')';
                return result;
            },
            cutHex:function (h) {
                return (h.charAt(0) == "#") ? h.substring(1, 7) : h
            },
            getBackgroundIconColor:function () {
                var colorIcon = $("#jsn-menu .mobilize-menu .link-menu-mobilize i").css("color");
                colorIcon = colorIcon.match(/\((.*?)\)/);
                $("#setStyle style").html("#jsn-menu .mobilize-menu .link-menu-mobilize:hover{ background-color: rgba(" + colorIcon[1] + ",0.15); }");
            },

            changeStyle:function (_this) {
                var self = this;
                var parents = $(_this).parents(".jsn-row-container").find(".jsn-column-container"), style = {}, styleIcon = {};
                var checkRegexBackground = false;
                var optionStyle = $(_this).parents(".jsn-row-container").find("input.jsn-input-style").val();
                var optionsStyle = "", containerShadown = [], containerTitle = {}, moduleStyle = {}, contentTitle = {}, contentBody = {}, optionsShadow = [], moduleContaienrBackgroundType = "", containerBackgroundType = "";
                if (optionStyle) {
                    optionsStyle = $.evalJSON(optionStyle);
                }
                if ($(_this).attr("data-action") == "logo") {
                    $.each(optionsStyle, function (i, val) {
                        if (val.key == "jsn_logo_content_alignment") {
                            style['text-align'] = val.value;
                        }
                    });
                }
                $.each(optionsStyle, function (i, val) {
                    if (val.key == $(parents).attr("id").replace(/-/g, "_") + "_container_ba_backgroundType") {
                        containerBackgroundType = val.value;
                    }
                    if (val.key == $(parents).attr("id").replace(/-/g, "_") + "_module_tabContainer_ba_backgroundType") {
                        moduleContaienrBackgroundType = val.value;
                    }
                });
                $.each(optionsStyle, function (i, val) {
                    var keyContainer = $(parents).attr("id").replace(/-/g, "_") + "_container_";
                    var keyContainerTitle = $(parents).attr("id").replace(/-/g, "_") + "_module_tabContent_title_";
                    var keyModuleContainer = $(parents).attr("id").replace(/-/g, "_") + "_module_tabContainer_";
                    var keyContentTitle = $(parents).attr("id").replace(/-/g, "_") + "_content_title_";
                    var keyContentBody = $(parents).attr("id").replace(/-/g, "_") + "_content_body_";
                    var key = val.key;
                    if (key) {
                        var nameInputSplit = key.split("_");
                        var nameInput = nameInputSplit[nameInputSplit.length - 1];
                        if (key.search(new RegExp(keyContainerTitle, "i")) > -1) {
                            if (val.value) {
                                switch (nameInput) {
                                    case "fontFace":
                                        containerTitle["font-family"] = val.value;
                                        var check = true;
                                        var arrCheck = ['Verdana', 'Georgia', 'Courier New', 'Arial', 'Tahoma', 'Trebuchet MS'];
                                        $("head").find("link.jsn-mobilize-font").each(function () {
                                            if ($(this).attr("id") == "google-font-" + val.value.replace(" ", "-")) {
                                                check = false;
                                            }
                                        });
                                        if (check && $.inArray(val.value, arrCheck) < 1) {
                                            $("head").append($("<link/>", {"class":"jsn-mobilize-font", "id":"google-font-" + val.value.replace(" ", "-"), "rel":"stylesheet", "type":"text/css", "href":"http://fonts.googleapis.com/css?family=" + val.value.replace(" ", "+")}));
                                        }
                                        break;
                                    case "fontStyle":
                                        if (val.value == "bold") {
                                            containerTitle["font-weight"] = val.value;
                                        }
                                        else {
                                            containerTitle["font-style"] = val.value;
                                        }
                                        break;
                                    case "fontSize":
                                        containerTitle["font-size"] = val.value + "px";
                                        break;
                                    case "iconColor":
                                    case "linkColor":
                                    case "fontColor":
                                        containerTitle["color"] = val.value;
                                        break;
                                }
                            }
                        }
                        if (key.search(new RegExp(keyContentTitle, "i")) > -1) {
                            if (val.value) {
                                switch (nameInput) {
                                    case "fontFace":
                                        contentTitle["font-family"] = val.value;
                                        var check = true;
                                        var arrCheck = ['Verdana', 'Georgia', 'Courier New', 'Arial', 'Tahoma', 'Trebuchet MS'];
                                        $("head").find("link.jsn-mobilize-font").each(function () {
                                            if ($(this).attr("id") == "google-font-" + val.value.replace(" ", "-")) {
                                                check = false;
                                            }
                                        });
                                        if (check && $.inArray(val.value, arrCheck) < 1) {
                                            $("head").append($("<link/>", {"class":"jsn-mobilize-font", "id":"google-font-" + val.value.replace(" ", "-"), "rel":"stylesheet", "type":"text/css", "href":"http://fonts.googleapis.com/css?family=" + val.value.replace(" ", "+")}));
                                        }
                                        break;
                                    case "fontStyle":
                                        if (val.value == "bold") {
                                            contentTitle["font-weight"] = val.value;
                                        }
                                        else {
                                            contentTitle["font-style"] = val.value;
                                        }
                                        break;
                                    case "fontSize":
                                        contentTitle["font-size"] = val.value + "px";
                                        break;
                                    case "iconColor":
                                    case "linkColor":
                                    case "fontColor":
                                        contentTitle["color"] = val.value;
                                        break;
                                }
                            }
                        }
                        if (key.search(new RegExp(keyContentBody, "i")) > -1) {
                            if (val.value) {
                                switch (nameInput) {
                                    case "fontFace":
                                        contentBody["font-family"] = val.value;
                                        var check = true;
                                        var arrCheck = ['Verdana', 'Georgia', 'Courier New', 'Arial', 'Tahoma', 'Trebuchet MS'];
                                        $("head").find("link.jsn-mobilize-font").each(function () {
                                            if ($(this).attr("id") == "google-font-" + val.value.replace(" ", "-")) {
                                                check = false;
                                            }
                                        });
                                        if (check && $.inArray(val.value, arrCheck) < 1) {
                                            $("head").append($("<link/>", {"class":"jsn-mobilize-font", "id":"google-font-" + val.value.replace(" ", "-"), "rel":"stylesheet", "type":"text/css", "href":"http://fonts.googleapis.com/css?family=" + val.value.replace(" ", "+")}));
                                        }
                                        break;
                                    case "fontStyle":
                                        if (val.value == "bold") {
                                            contentBody["font-weight"] = val.value;
                                        }
                                        else {
                                            contentBody["font-style"] = val.value;
                                        }
                                        break;
                                    case "fontSize":
                                        contentBody["font-size"] = val.value + "px";
                                        break;
                                    case "iconColor":
                                    case "linkColor":
                                    case "fontColor":
                                        contentBody["color"] = val.value;
                                        break;
                                }
                            }
                        }
                        if (key.search(new RegExp(keyModuleContainer, "i")) > -1) {
                            if (val.value) {
                                switch (nameInput) {
                                    case "soildColor":
                                        if (moduleContaienrBackgroundType == "Solid") {
                                            moduleStyle["background"] = val.value;
                                        }
                                        break;
                                    case "gradientColor":
                                        if (moduleContaienrBackgroundType == "Gradient") {
                                            checkRegexBackground = true;
                                            moduleStyle["background"] = val.value;
                                        }
                                        break;
                                    case "borderThickness":
                                        var border = val.value;
                                        border = border ? border : 0;
                                        moduleStyle["border"] = border + "px";
                                        break;
                                    case "borderStyle":
                                        moduleStyle["border-style"] = val.value;
                                        break;
                                    case "borderColor":
                                        moduleStyle["border-color"] = val.value;
                                        break;
                                    case "paddingleft":
                                        moduleStyle["padding-left"] = val.value + "px";
                                        break;
                                    case "paddingright":
                                        moduleStyle["padding-right"] = val.value + "px";
                                        break;
                                    case "paddingtop":
                                        moduleStyle["padding-top"] = val.value + "px";
                                        break;
                                    case "paddingbottom":
                                        moduleStyle["padding-bottom"] = val.value + "px";
                                        break;
                                    case "marginleft":
                                        moduleStyle["margin-left"] = val.value + "px";
                                        break;
                                    case "marginright":
                                        moduleStyle["margin-right"] = val.value + "px";
                                        break;
                                    case "margintop":
                                        moduleStyle["margin-top"] = val.value + "px";
                                        break;
                                    case "marginbottom":
                                        moduleStyle["margin-bottom"] = val.value + "px";
                                        break;
                                    case "roundedCornerRadius":
                                        var border = val.value;
                                        border = border ? border : 0;
                                        moduleStyle["border-radius"] = border + "px";
                                        break;
                                    case "shadowSpread":

                                        if (val.value > 0) {
                                            var shadow = val.value;
                                            shadow = shadow ? shadow : 0;
                                            optionsShadow.push("0px 0px 5px " + shadow + "px");
                                        } else {
                                            optionsShadow.push("0px");
                                        }

                                        break;
                                    case "shadowColor":
                                        optionsShadow.push(self.convertHextToRgba(val.value, 25));
                                        break;
                                }
                            }
                        }
                        if (key.search(new RegExp(keyContainer, "i")) > -1) {
                            if (val.value) {
                                switch (nameInput) {
                                    case "soildColor":
                                        if (containerBackgroundType == "Solid") {
                                            style["background"] = val.value;
                                        }
                                        break;
                                    case "gradientColor":
                                        if (containerBackgroundType == "Gradient") {
                                            checkRegexBackground = true;
                                            style["background"] = val.value;
                                        }
                                        break;
                                    case "borderThickness":
                                        var border = val.value;
                                        border = border ? border : 0;
                                        style["border"] = border + "px";
                                        break;
                                    case "borderStyle":
                                        style["border-style"] = val.value;
                                        break;
                                    case "borderColor":
                                        style["border-color"] = val.value;
                                        break;
                                    case "paddingleft":
                                        style["padding-left"] = val.value + "px";
                                        break;
                                    case "paddingright":
                                        style["padding-right"] = val.value + "px";
                                        break;
                                    case "paddingtop":
                                        style["padding-top"] = val.value + "px";
                                        break;
                                    case "paddingbottom":
                                        style["padding-bottom"] = val.value + "px";
                                        break;
                                    case "iconColor":
                                        styleIcon['color'] = val.value;
                                        break;
                                    case "shadowSpread":
                                        if (val.value > 0) {
                                            var shadow = val.value;
                                            shadow = shadow ? shadow : 0;
                                            containerShadown.push("0px 0px 5px " + shadow + "px");
                                        } else {
                                            containerShadown.push("0px 0px 0px 0px");
                                        }
                                        break;
                                    case "shadowColor":
                                        containerShadown.push(self.convertHextToRgba(val.value, 25));
                                        break;
                                }
                            }
                        }
                    }
                });
                if (optionsShadow && optionsShadow.length > 0) {

                    moduleStyle["webkit-box-shadow"] = optionsShadow.join(" ");
                    moduleStyle["box-shadow"] = optionsShadow.join(" ");
                }

                if (moduleStyle) {
                    $(parents).find(".jsn-element").removeAttr("style");
                    $(parents).find(".jsn-element").css(moduleStyle);
                    var tmpGetCss = $("<div/>");
                    $(tmpGetCss).css(moduleStyle);
                    $(parents).find(".jsn-column").attr("data-module-style", $(tmpGetCss).attr("style"));

                }
                if (containerTitle) {
                    $(parents).find(".jsn-element-content").removeAttr("style");
                    $(parents).find(".jsn-element-content").css(containerTitle);
                    var tmpGetCss = $("<div/>");
                    $(tmpGetCss).css(containerTitle);
                    $(parents).find(".jsn-column").attr("data-title-style", $(tmpGetCss).attr("style"));
                }
                if (contentTitle) {
                    $(parents).find("h2").css(contentTitle);
                }
                if (contentBody) {
                    $(parents).find("p").css(contentBody);
                }
                if (containerShadown && optionsShadow.length > 0) {
                    style["webkit-box-shadowbox-shadow"] = containerShadown.join(" ");
                    style["box-shadow"] = containerShadown.join(" ");
                }
                if (style) {
                    parents.css(style);
                    if (checkRegexBackground == true) {
                        var background = style.background;
                        var op = background.match(/(.*?)\((.*?), (.*?)\s(.*?), (.*?)\s(.*?)\)/);
                        if (op) {
                            var cssBackground = '';
                            var opt2 = '', opt3 = '', opt4 = '', opt5 = '', opt6 = '';
                            if (op[2]) {
                                opt2 = op[2];
                            }
                            if (op[3]) {
                                opt3 = op[3];
                            }
                            if (op[4]) {
                                opt4 = op[4];
                            }
                            if (op[5]) {
                                opt5 = op[5];
                            }
                            if (op[6]) {
                                opt6 = op[6];
                            }
                            cssBackground += "background: " + opt3 + ";";
                            cssBackground += "background:linear-gradient(135deg, " + opt3 + " " + opt4 + "," + opt5 + " " + opt6 + ");";
                            cssBackground += "background:-moz-linear-gradient(" + opt2 + ", " + opt3 + " " + opt4 + ", " + opt5 + " " + opt6 + ");";
                            cssBackground += "background:-webkit-gradient(linear, left top, right bottom, color-stop(" + opt4 + "," + opt3 + "), color-stop(" + opt6 + "," + opt5 + "));";
                            cssBackground += "background:-webkit-linear-gradient(" + opt2 + ", " + opt3 + " " + opt4 + "," + opt5 + " " + opt6 + ");";
                            cssBackground += "background:-o-linear-gradient(" + opt2 + ", " + opt3 + " " + opt4 + "," + opt5 + " " + opt6 + ");";
                            cssBackground += "background:-ms-linear-gradient(" + opt2 + ", " + op[3] + " " + opt4 + "," + opt5 + " " + opt6 + ");";
                            cssBackground += "filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='" + opt3 + "', endColorstr='" + opt5 + "',GradientType=1 );";
                            var getStyleParents = $(parents).attr("style");
                            $(parents).attr("style", getStyleParents + ";" + cssBackground);
                        }

                    }
                    if (styleIcon) {
                        parents.find(".link-menu-mobilize i").removeAttr("style");
                        parents.find(".link-menu-mobilize i").css(styleIcon);
                        self.getBackgroundIconColor();
                    }
                }
            },
            designStyleSwitcher:function (_this) {
                var self = this, name = $(_this).parents(".jsn-row-container").find(".jsn-column-container").attr("id");
                name = name.replace(/\-/g, "_");
                var options = {
                    container:{
                        title:"Container",
                        type:"tab",
                        tabContent:{
                            background:{
                                title:"Background",
                                type:"fieldset",
                                fieldsetContent:{
                                    comboContentBorder:self.generateStyle.generateStyleCombo(name + "_container_bo", "comboContentBorder"),
                                    comboContentBackground:self.generateStyle.generateStyleCombo(name + "_container_ba", "comboContentBackground")
                                    // comboContentShadow:self.generateStyle.generateStyleCombo(name + "_container_sh", "comboContentShadow"),
                                    // comboContentRadius:self.generateStyle.generateStyleCombo(name + "_container_bo", "comboContentRadius")
                                }
                            },
                            spacing:{
                                title:"Spacing",
                                type:"fieldset",
                                fieldsetContent:{
                                    padding:self.generateStyle.generateStyleCombo(name + "_container_sp", "comboPadding")

                                }
                            }
                        }
                    }
                };
                return options;
            },
            designStyleMainBody:function (_this) {
                var self = this, name = $(_this).parents(".jsn-row-container").find(".jsn-column-container").attr("id");
                name = name.replace(/\-/g, "_");
                var options = {
                    container:{
                        title:"Container",
                        type:"tab",
                        tabContent:{
                            background:{
                                title:"Background",
                                type:"fieldset",
                                fieldsetContent:{
                                    comboContentBorder:self.generateStyle.generateStyleCombo(name + "_container_bo", "comboContentBorder"),
                                    comboContentBackground:self.generateStyle.generateStyleCombo(name + "_container_ba", "comboContentBackground"),
                                    comboContentShadow:self.generateStyle.generateStyleCombo(name + "_container_sh", "comboContentShadow"),
                                    comboContentRadius:self.generateStyle.generateStyleCombo(name + "_container_bo", "comboContentRadius")
                                }
                            },
                            spacing:{
                                title:"Spacing",
                                type:"fieldset",
                                fieldsetContent:{
                                    padding:self.generateStyle.generateStyleCombo(name + "_container_sp", "comboPadding")

                                }
                            }
                        }
                    },
                    content:{
                        title:"Content",
                        type:"tab",
                        tabContent:{
                            title:{
                                title:"Title",
                                type:"fieldset",
                                fieldsetContent:{
                                    comboContentFace:self.generateStyle.generateStyleCombo(name + "_content_title_fo", "comboContentFace"),
                                    comboContentAttributes:self.generateStyle.generateStyleCombo(name + "_content_title_fo", "comboContentAttributes")
                                }
                            },
                            body:{
                                title:"Body",
                                type:"fieldset",
                                fieldsetContent:{
                                    comboContentFace:self.generateStyle.generateStyleCombo(name + "_content_body_fo", "comboContentFace"),
                                    comboContentAttributes:self.generateStyle.generateStyleCombo(name + "_content_body_fo", "comboContentAttributes"),
                                    linkColor:{
                                        name:name + "_content_link_linkColor",
                                        label:"Link Color",
                                        type:'color',
                                        attrs:{
                                            class:"jsn-select-color jsn-linkColor input-small"
                                        }
                                    }
                                }
                            }
                        }
                    }
                };
                return options;
            },
            designStyleModule:function (_this) {
                var self = this, name = $(_this).parents(".jsn-row-container").find(".jsn-column-container").attr("id");
                name = name.replace(/\-/g, "_");
                var options = {
                    container:{
                        title:"Container",
                        type:"tab",
                        tabContent:{
                            background:{
                                title:"Background",
                                type:"fieldset",
                                fieldsetContent:{
                                    comboContentBorder:self.generateStyle.generateStyleCombo(name + "_container_bo", "comboContentBorder"),
                                    comboContentBackground:self.generateStyle.generateStyleCombo(name + "_container_ba", "comboContentBackground")
                                }
                            },
                            spacing:{
                                title:"Spacing",
                                type:"fieldset",
                                fieldsetContent:{
                                    padding:self.generateStyle.generateStyleCombo(name + "_container_sp", "comboPadding")
                                }
                            }
                        }
                    },
                    module:{
                        title:"Module",
                        type:"tab",
                        subTabs:{
                            subtabcontainer:{
                                title:"Container",
                                type:"tab",
                                tabContent:{
                                    background:{
                                        title:"Background",
                                        type:"fieldset",
                                        fieldsetContent:{
                                            comboContentBorder:self.generateStyle.generateStyleCombo(name + "_module_tabContainer_bo", "comboContentBorder"),
                                            comboContentBackground:self.generateStyle.generateStyleCombo(name + "_module_tabContainer_ba", "comboContentBackground"),
                                            roundedCornerRadius:self.generateStyle.generateStyleCombo(name + "_module_tabContainer_bo", "comboContentRadius"),
                                            comboContentShadow:self.generateStyle.generateStyleCombo(name + "_module_tabContainer_sh", "comboContentShadow")
                                        }
                                    },
                                    spacing:{
                                        title:"Spacing",
                                        type:"fieldset",
                                        fieldsetContent:{
                                            margin:self.generateStyle.generateStyleCombo(name + "_module_tabContainer_sp", "comboMargin"),
                                            padding:self.generateStyle.generateStyleCombo(name + "_module_tabContainer_sp", "comboPadding")
                                        }
                                    }
                                }
                            },
                            subtabContent:{
                                title:"Content",
                                type:"tab",
                                tabContent:{
                                    Title:{
                                        title:"Title",
                                        type:"fieldset",
                                        fieldsetContent:{
                                            comboContentFace:self.generateStyle.generateStyleCombo(name + "_module_tabContent_title_fo", "comboContentFace"),
                                            comboContentAttributes:self.generateStyle.generateStyleCombo(name + "_module_tabContent_title_fo", "comboContentAttributes")
                                        }
                                    },
                                    Body:{
                                        title:"Body",
                                        type:"fieldset",
                                        fieldsetContent:{
                                            comboContentFace:self.generateStyle.generateStyleCombo(name + "_module_tabContent_body_fo", "comboContentFace"),
                                            comboContentAttributes:self.generateStyle.generateStyleCombo(name + "_module_tabContent_body_fo", "comboContentAttributes"),
                                            linkColor:{
                                                name:name + "_module_tabContent_link_linkColor",
                                                label:"Link Color",
                                                type:'color',
                                                varlue:'#93b516',
                                                attrs:{
                                                    class:"jsn-select-color jsn-linkColor input-small"
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                };
                return options;
            },
            designStyleLogo:function (_this) {
                var self = this, name = $(_this).parents(".jsn-row-container").find(".jsn-column-container").attr("id");
                name = name.replace(/\-/g, "_");
                var options = {
                    container:{
                        title:"Container",
                        type:"tab",
                        tabContent:{
                            background:{
                                title:"Background",
                                type:"fieldset",
                                fieldsetContent:{
                                    comboContentBorder:self.generateStyle.generateStyleCombo(name + "_container_bo", "comboContentBorder"),
                                    comboContentBackground:self.generateStyle.generateStyleCombo(name + "_container_ba", "comboContentBackground")
                                }
                            },
                            spacing:{
                                title:"Spacing",
                                type:"fieldset",
                                fieldsetContent:{
                                    padding:self.generateStyle.generateStyleCombo(name + "_container_sp", "comboPadding")
                                }
                            }
                        }
                    },
                    content:{
                        title:"Content",
                        type:"tab",
                        tabContent:{
                            background:{
                                title:"Logo",
                                type:"fieldset",
                                fieldsetContent:{
                                    alignment:{
                                        type:'select',
                                        label:"Alignment",
                                        name:name + "_content_alignment",
                                        options:{
                                            "left":"Left",
                                            "center":"Center",
                                            "right":"Right"
                                        },
                                        attrs:{
                                            'class':'input-small'
                                        }
                                    }
                                }
                            }
                        }
                    }
                };
                return options;
            },
            designStyleMenu:function (_this) {

                var self = this, name = $(_this).parents(".jsn-row-container").find(".jsn-column-container").attr("id");
                name = name.replace(/\-/g, "_");
                var options = {
                    container:{
                        title:"Container",
                        type:"tab",
                        tabContent:{
                            background:{
                                title:"Background",
                                type:"fieldset",
                                fieldsetContent:{
                                    comboContentBorder:self.generateStyle.generateStyleCombo(name + "_container_bo", "comboContentBorder"),
                                    comboContentBackground:self.generateStyle.generateStyleCombo(name + "_container_ba", "comboContentBackground"),
                                    activeColor:{
                                        name:name + "_container_ba_activeColor",
                                        type:'color',
                                        label:"Active BG Color",
                                        attrs:{
                                            class:"jsn-select-color jsn-activeColor input-small"
                                        }
                                    }
                                }
                            },
                            Foreground:{
                                title:"Foreground",
                                type:"fieldset",
                                fieldsetContent:{
                                    /*
                                     iconColor:{
                                     type:'color',
                                     label:"Icon Color",
                                     name:name + "_container_ic_iconColor",
                                     attrs:{
                                     'class':'jsn-select-color jsn-iconColor input-small'
                                     }
                                     }
                                     */
                                    iconColor:{
                                        type:'select',
                                        label:"Icon Color",
                                        name:name + "_container_ic_iconColor",
                                        options:{
                                            "white":"white",
                                            "black":"black"
                                        },
                                        attrs:{
                                            'class':'input-small'
                                        }
                                    }
                                }
                            }
                        }
                    },
                    sublevel1:{
                        title:"Sublevel 1",
                        type:"tab",
                        tabContent:{
                            background:{
                                title:"Background",
                                type:"fieldset",
                                fieldsetContent:{
                                    comboContent:self.generateStyle.generateStyleCombo(name + "_sublevel1_bo", "comboContent"),
                                    normalColor:{
                                        name:name + "_sublevel1_ba_normalColor",
                                        type:'color',
                                        label:"Normal BG Color",
                                        attrs:{
                                            class:"jsn-select-color jsn-normalColor input-small"
                                        }
                                    },
                                    activeColor:{
                                        name:name + "_sublevel1_ba_activeColor",
                                        type:'color',
                                        label:"Active BG Color",
                                        attrs:{
                                            class:"jsn-select-color jsn-activeColor input-small"
                                        }
                                    }
                                }
                            },
                            font:{
                                title:"Foreground",
                                type:"fieldset",
                                fieldsetContent:{
                                    comboContentFace:self.generateStyle.generateStyleCombo(name + "_sublevel1_fo", "comboContentFace"),
                                    comboContentAttributes:self.generateStyle.generateStyleCombo(name + "_sublevel1_fo", "comboContentAttributes")
                                }
                            }
                        }
                    },
                    sublevel2:{
                        title:"Sublevel 2",
                        type:"tab",
                        tabContent:{
                            background:{
                                title:"Background",
                                type:"fieldset",
                                fieldsetContent:{
                                    normalColor:{
                                        name:name + "_sublevel2_ba_normalColor",
                                        type:'color',
                                        label:"Normal BG Color",
                                        attrs:{
                                            class:"jsn-select-color jsn-normalColor input-small"
                                        }
                                    },
                                    activeColor:{
                                        name:name + "_sublevel2_ba_activeColor",
                                        type:'color',
                                        label:"Active BG Color",
                                        attrs:{
                                            class:"jsn-select-color jsn-activeColor input-small"
                                        }
                                    }
                                }
                            },
                            font:{
                                title:"Foreground",
                                type:"fieldset",
                                fieldsetContent:{
                                    comboContentFace:self.generateStyle.generateStyleCombo(name + "_sublevel2_fo", "comboContentFace"),
                                    comboContentAttributes:self.generateStyle.generateStyleCombo(name + "_sublevel2_fo", "comboContentAttributes")
                                }
                            }
                        }
                    }
                };
                return options;
            },
            profileStyleList:function () {
                var style = {
                    android:{
                        title:"Android",
                        thumbnail:"components/com_mobilize/assets/images/thumbnail/android.jpg",
                        style:{
                            'jsn_menu':'[{"key":"jsn_menu_container_bo_borderThickness","value":"1"},{"key":"jsn_menu_container_bo_borderStyle","value":"solid"},{"key":"jsn_menu_container_bo_borderColor","value":"#363636"},{"key":"jsn_menu_container_ba_backgroundType","value":"Solid"},{"key":"jsn_menu_container_ba_soildColor","value":"#2e2e2e"},{"key":"jsn_menu_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #a846a8 0%, #afb0ad 100%)"},{"key":"jsn_menu_container_ba_activeColor","value":"#303030"},{"key":"jsn_menu_container_ic_iconColor","value":"#ffffff"},{"key":"jsn_menu_sublevel1_bo_sublevel1_bo_borderThickness","value":"1"},{"key":"jsn_menu_sublevel1_bo_sublevel1_bo_borderStyle","value":"solid"},{"key":"jsn_menu_sublevel1_bo_sublevel1_bo_borderColor","value":"#333333"},{"key":"jsn_menu_sublevel1_ba_normalColor","value":"#262626"},{"key":"jsn_menu_sublevel1_ba_activeColor","value":"#000000"},{"value":""},{"value":""},{"key":"jsn_menu_sublevel1_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_menu_sublevel1_fo_fontFace","value":"Open Sans"},{"key":"jsn_menu_sublevel1_fo_fontSize","value":""},{"key":"jsn_menu_sublevel1_fo_fontStyle","value":"inherit"},{"key":"jsn_menu_sublevel1_fo_fontColor","value":"#ffffff"},{"key":"jsn_menu_sublevel2_ba_normalColor","value":"#1f1f1f"},{"value":""},{"value":""},{"key":"jsn_menu_sublevel2_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_menu_sublevel2_fo_fontFace","value":"Verdana"},{"key":"jsn_menu_sublevel2_fo_fontSize","value":""},{"key":"jsn_menu_sublevel2_fo_fontStyle","value":"inherit"},{"key":"jsn_menu_sublevel2_fo_fontColor","value":"#ffffff"}]',
                            'jsn_logo':'[{"key":"jsn_logo_container_bo_borderThickness","value":""},{"key":"jsn_logo_container_bo_borderStyle","value":"solid"},{"key":"jsn_logo_container_bo_borderColor","value":"#ffffff"},{"key":"jsn_logo_container_ba_backgroundType","value":"Solid"},{"key":"jsn_logo_container_ba_soildColor","value":"#141414"},{"key":"jsn_logo_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_logo_container_sp_paddingleft","value":"20"},{"key":"jsn_logo_container_sp_paddingright","value":"20"},{"key":"jsn_logo_container_sp_paddingbottom","value":"10"},{"key":"jsn_logo_container_sp_paddingtop","value":"10"},{"key":"jsn_logo_content_alignment","value":"center"}]',
                            'jsn_mobile_tool':'[{"key":"jsn_mobile_tool_container_bo_borderThickness","value":""},{"key":"jsn_mobile_tool_container_bo_borderStyle","value":"solid"},{"key":"jsn_mobile_tool_container_bo_borderColor","value":"#ffffff"},{"key":"jsn_mobile_tool_container_ba_backgroundType","value":"Solid"},{"key":"jsn_mobile_tool_container_ba_soildColor","value":"#141414"},{"key":"jsn_mobile_tool_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_mobile_tool_container_sp_paddingleft","value":""},{"key":"jsn_mobile_tool_container_sp_paddingright","value":""},{"key":"jsn_mobile_tool_container_sp_paddingbottom","value":""},{"key":"jsn_mobile_tool_container_sp_paddingtop","value":""},{"key":"jsn_mobile_tool_module_tabContainer_bo_borderThickness","value":"1"},{"key":"jsn_mobile_tool_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_mobile_tool_module_tabContainer_bo_borderColor","value":"#2b2b2b"},{"key":"jsn_mobile_tool_module_tabContainer_ba_backgroundType","value":"Gradient"},{"key":"jsn_mobile_tool_module_tabContainer_ba_soildColor","value":"#ffffff"},{"key":"jsn_mobile_tool_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #f2f2f2 0%, #ffffff 100%)"},{"key":"jsn_mobile_tool_module_tabContainer_bo_roundedCornerRadius","value":"3"},{"key":"jsn_mobile_tool_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_mobile_tool_module_tabContainer_sh_shadowColor","value":"#000000"},{"key":"jsn_mobile_tool_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_mobile_tool_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_mobile_tool_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_mobile_tool_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_mobile_tool_module_tabContainer_sp_paddingleft","value":"15"},{"key":"jsn_mobile_tool_module_tabContainer_sp_paddingright","value":"15"},{"key":"jsn_mobile_tool_module_tabContainer_sp_paddingbottom","value":"10"},{"key":"jsn_mobile_tool_module_tabContainer_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontFace","value":"Lato"},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontSize","value":"18"},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontColor","value":"#000000"},{"value":""},{"value":""},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontFace","value":"Open Sans"},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontSize","value":""},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontColor","value":"#000000"},{"key":"jsn_mobile_tool_module_tabContent_link_linkColor","value":"#227bb3"}]',
                            'jsn_content_top':'[{"key":"jsn_content_top_container_bo_borderThickness","value":""},{"key":"jsn_content_top_container_bo_borderStyle","value":"solid"},{"key":"jsn_content_top_container_bo_borderColor","value":""},{"key":"jsn_content_top_container_ba_backgroundType","value":"Solid"},{"key":"jsn_content_top_container_ba_soildColor","value":"#999999"},{"key":"jsn_content_top_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_content_top_container_sp_paddingleft","value":""},{"key":"jsn_content_top_container_sp_paddingright","value":""},{"key":"jsn_content_top_container_sp_paddingbottom","value":""},{"key":"jsn_content_top_container_sp_paddingtop","value":""},{"key":"jsn_content_top_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_content_top_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_content_top_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_content_top_module_tabContainer_ba_backgroundType","value":"Gradient"},{"key":"jsn_content_top_module_tabContainer_ba_soildColor","value":"#5eb295"},{"key":"jsn_content_top_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #f0f0f0 0%, #ffffff 100%)"},{"key":"jsn_content_top_module_tabContainer_bo_roundedCornerRadius","value":"3"},{"key":"jsn_content_top_module_tabContainer_sh_shadowSpread","value":"1"},{"key":"jsn_content_top_module_tabContainer_sh_shadowColor","value":"#595959"},{"key":"jsn_content_top_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_content_top_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_content_top_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_content_top_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_content_top_module_tabContainer_sp_paddingleft","value":"15"},{"key":"jsn_content_top_module_tabContainer_sp_paddingright","value":"15"},{"key":"jsn_content_top_module_tabContainer_sp_paddingbottom","value":"10"},{"key":"jsn_content_top_module_tabContainer_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_content_top_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_content_top_module_tabContent_title_fo_fontFace","value":"Droid Sans"},{"key":"jsn_content_top_module_tabContent_title_fo_fontSize","value":"18"},{"key":"jsn_content_top_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_content_top_module_tabContent_title_fo_fontColor","value":"#000000"},{"value":""},{"value":""},{"key":"jsn_content_top_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_content_top_module_tabContent_body_fo_fontFace","value":"Droid Sans"},{"key":"jsn_content_top_module_tabContent_body_fo_fontSize","value":""},{"key":"jsn_content_top_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_content_top_module_tabContent_body_fo_fontColor","value":"#000000"},{"key":"jsn_content_top_module_tabContent_link_linkColor","value":"#227bb3"}]',
                            'jsn_user_top':'[{"key":"jsn_user_top_container_bo_borderThickness","value":""},{"key":"jsn_user_top_container_bo_borderStyle","value":"solid"},{"key":"jsn_user_top_container_bo_borderColor","value":"#227bb3"},{"key":"jsn_user_top_container_ba_backgroundType","value":"Solid"},{"key":"jsn_user_top_container_ba_soildColor","value":"#141414"},{"key":"jsn_user_top_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_user_top_container_sp_paddingleft","value":""},{"key":"jsn_user_top_container_sp_paddingright","value":""},{"key":"jsn_user_top_container_sp_paddingbottom","value":""},{"key":"jsn_user_top_container_sp_paddingtop","value":""},{"key":"jsn_user_top_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_user_top_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_user_top_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_user_top_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_user_top_module_tabContainer_ba_soildColor","value":"#141414"},{"key":"jsn_user_top_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_user_top_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_user_top_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_user_top_module_tabContainer_sh_shadowColor","value":""},{"key":"jsn_user_top_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_user_top_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_user_top_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_user_top_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_user_top_module_tabContainer_sp_paddingleft","value":""},{"key":"jsn_user_top_module_tabContainer_sp_paddingright","value":""},{"key":"jsn_user_top_module_tabContainer_sp_paddingbottom","value":""},{"key":"jsn_user_top_module_tabContainer_sp_paddingtop","value":""},{"value":""},{"value":""},{"key":"jsn_user_top_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_user_top_module_tabContent_title_fo_fontFace","value":"Droid Sans"},{"key":"jsn_user_top_module_tabContent_title_fo_fontSize","value":"18"},{"key":"jsn_user_top_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_user_top_module_tabContent_title_fo_fontColor","value":"#ffffff"},{"value":""},{"value":""},{"key":"jsn_user_top_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_user_top_module_tabContent_body_fo_fontFace","value":"Droid Sans"},{"key":"jsn_user_top_module_tabContent_body_fo_fontSize","value":""},{"key":"jsn_user_top_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_user_top_module_tabContent_body_fo_fontColor","value":"#ffffff"},{"key":"jsn_user_top_module_tabContent_link_linkColor","value":"#227bb3"}]',
                            'jsn_mainbody':'[{"key":"jsn_mainbody_container_bo_borderThickness","value":""},{"key":"jsn_mainbody_container_bo_borderStyle","value":"solid"},{"key":"jsn_mainbody_container_bo_borderColor","value":"#ffffff"},{"key":"jsn_mainbody_container_ba_backgroundType","value":"Solid"},{"key":"jsn_mainbody_container_ba_soildColor","value":"#141414"},{"key":"jsn_mainbody_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_mainbody_container_sh_shadowSpread","value":"0"},{"key":"jsn_mainbody_container_sh_shadowColor","value":"#ffffff"},{"key":"jsn_mainbody_container_bo_roundedCornerRadius","value":"0"},{"key":"jsn_mainbody_container_sp_paddingleft","value":"10"},{"key":"jsn_mainbody_container_sp_paddingright","value":"10"},{"key":"jsn_mainbody_container_sp_paddingbottom","value":"10"},{"key":"jsn_mainbody_container_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_mainbody_content_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_mainbody_content_title_fo_fontFace","value":"Droid Sans"},{"key":"jsn_mainbody_content_title_fo_fontSize","value":"20"},{"key":"jsn_mainbody_content_title_fo_fontStyle","value":"inherit"},{"key":"jsn_mainbody_content_title_fo_fontColor","value":"#ffffff"},{"value":""},{"value":""},{"key":"jsn_mainbody_content_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_mainbody_content_body_fo_fontFace","value":"Droid Sans"},{"key":"jsn_mainbody_content_body_fo_fontSize","value":""},{"key":"jsn_mainbody_content_body_fo_fontStyle","value":"inherit"},{"key":"jsn_mainbody_content_body_fo_fontColor","value":"#ffffff"},{"key":"jsn_mainbody_content_link_linkColor","value":"#227bb3"}]',
                            'jsn_user_bottom':'[{"key":"jsn_user_bottom_container_bo_borderThickness","value":""},{"key":"jsn_user_bottom_container_bo_borderStyle","value":"solid"},{"key":"jsn_user_bottom_container_bo_borderColor","value":""},{"key":"jsn_user_bottom_container_ba_backgroundType","value":"Solid"},{"key":"jsn_user_bottom_container_ba_soildColor","value":"#141414"},{"key":"jsn_user_bottom_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_user_bottom_container_sp_paddingleft","value":""},{"key":"jsn_user_bottom_container_sp_paddingright","value":""},{"key":"jsn_user_bottom_container_sp_paddingbottom","value":""},{"key":"jsn_user_bottom_container_sp_paddingtop","value":""},{"key":"jsn_user_bottom_module_tabContainer_bo_borderThickness","value":"1"},{"key":"jsn_user_bottom_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_user_bottom_module_tabContainer_bo_borderColor","value":"#4e4e4e"},{"key":"jsn_user_bottom_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_user_bottom_module_tabContainer_ba_soildColor","value":"#000000"},{"key":"jsn_user_bottom_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_user_bottom_module_tabContainer_bo_roundedCornerRadius","value":"3"},{"key":"jsn_user_bottom_module_tabContainer_sh_shadowSpread","value":"1"},{"key":"jsn_user_bottom_module_tabContainer_sh_shadowColor","value":"#000000"},{"key":"jsn_user_bottom_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_user_bottom_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_user_bottom_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_user_bottom_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_user_bottom_module_tabContainer_sp_paddingleft","value":"15"},{"key":"jsn_user_bottom_module_tabContainer_sp_paddingright","value":"15"},{"key":"jsn_user_bottom_module_tabContainer_sp_paddingbottom","value":"10"},{"key":"jsn_user_bottom_module_tabContainer_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontFace","value":"Droid Sans"},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontSize","value":"18"},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontColor","value":"#ffffff"},{"value":""},{"value":""},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontFace","value":"Droid Sans"},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontSize","value":""},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontColor","value":"#ffffff"},{"key":"jsn_user_bottom_module_tabContent_link_linkColor","value":"#2380c2"}]',
                            'jsn_content_bottom':'[{"key":"jsn_content_bottom_container_bo_borderThickness","value":""},{"key":"jsn_content_bottom_container_bo_borderStyle","value":"solid"},{"key":"jsn_content_bottom_container_bo_borderColor","value":""},{"key":"jsn_content_bottom_container_ba_backgroundType","value":"Gradient"},{"key":"jsn_content_bottom_container_ba_soildColor","value":"#000000"},{"key":"jsn_content_bottom_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #6f9425 0%, #95c732 100%)"},{"key":"jsn_content_bottom_container_sp_paddingleft","value":""},{"key":"jsn_content_bottom_container_sp_paddingright","value":""},{"key":"jsn_content_bottom_container_sp_paddingbottom","value":""},{"key":"jsn_content_bottom_container_sp_paddingtop","value":""},{"key":"jsn_content_bottom_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_content_bottom_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_content_bottom_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_content_bottom_module_tabContainer_ba_backgroundType","value":"Gradient"},{"key":"jsn_content_bottom_module_tabContainer_ba_soildColor","value":"#cd471a"},{"key":"jsn_content_bottom_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #e8e8e8 100%)"},{"key":"jsn_content_bottom_module_tabContainer_bo_roundedCornerRadius","value":"3"},{"key":"jsn_content_bottom_module_tabContainer_sh_shadowSpread","value":"1"},{"key":"jsn_content_bottom_module_tabContainer_sh_shadowColor","value":"#636363"},{"key":"jsn_content_bottom_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_content_bottom_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_content_bottom_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_content_bottom_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_content_bottom_module_tabContainer_sp_paddingleft","value":"15"},{"key":"jsn_content_bottom_module_tabContainer_sp_paddingright","value":"15"},{"key":"jsn_content_bottom_module_tabContainer_sp_paddingbottom","value":"10"},{"key":"jsn_content_bottom_module_tabContainer_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontFace","value":"Droid Sans"},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontSize","value":"18"},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontColor","value":"#000000"},{"value":""},{"value":""},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontFace","value":"Droid Sans"},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontSize","value":""},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontColor","value":"#000000"},{"key":"jsn_content_bottom_module_tabContent_link_linkColor","value":"#2085b0"}]',
                            'jsn_footer':'[{"key":"jsn_footer_container_bo_borderThickness","value":"1"},{"key":"jsn_footer_container_bo_borderStyle","value":"solid"},{"key":"jsn_footer_container_bo_borderColor","value":"#000000"},{"key":"jsn_footer_container_ba_backgroundType","value":"Solid"},{"key":"jsn_footer_container_ba_soildColor","value":"#141414"},{"key":"jsn_footer_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_footer_container_sp_paddingleft","value":""},{"key":"jsn_footer_container_sp_paddingright","value":""},{"key":"jsn_footer_container_sp_paddingbottom","value":""},{"key":"jsn_footer_container_sp_paddingtop","value":""},{"key":"jsn_footer_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_footer_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_footer_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_footer_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_footer_module_tabContainer_ba_soildColor","value":""},{"key":"jsn_footer_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_footer_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_footer_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_footer_module_tabContainer_sh_shadowColor","value":""},{"key":"jsn_footer_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_footer_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_footer_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_footer_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_footer_module_tabContainer_sp_paddingleft","value":""},{"key":"jsn_footer_module_tabContainer_sp_paddingright","value":""},{"key":"jsn_footer_module_tabContainer_sp_paddingbottom","value":""},{"key":"jsn_footer_module_tabContainer_sp_paddingtop","value":""},{"value":""},{"value":""},{"key":"jsn_footer_module_tabContent_title_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_footer_module_tabContent_title_fo_fontFace","value":"Verdana"},{"key":"jsn_footer_module_tabContent_title_fo_fontSize","value":"18"},{"key":"jsn_footer_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_footer_module_tabContent_title_fo_fontColor","value":"#ffffff"},{"value":""},{"value":""},{"key":"jsn_footer_module_tabContent_body_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_footer_module_tabContent_body_fo_fontFace","value":"Verdana"},{"key":"jsn_footer_module_tabContent_body_fo_fontSize","value":"11"},{"key":"jsn_footer_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_footer_module_tabContent_body_fo_fontColor","value":"#ffffff"},{"key":"jsn_footer_module_tabContent_link_linkColor","value":""}]',
                            'jsn_switcher':'[{"key":"jsn_switcher_container_bo_borderThickness","value":"0"},{"key":"jsn_switcher_container_bo_borderStyle","value":"solid"},{"key":"jsn_switcher_container_bo_borderColor","value":"#1f1f1f"},{"key":"jsn_switcher_container_ba_backgroundType","value":"Solid"},{"key":"jsn_switcher_container_ba_soildColor","value":"#000000"},{"key":"jsn_switcher_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_switcher_container_sp_paddingleft","value":""},{"key":"jsn_switcher_container_sp_paddingright","value":""},{"key":"jsn_switcher_container_sp_paddingbottom","value":"10"},{"key":"jsn_switcher_container_sp_paddingtop","value":"10"}]'
                        }
                    },
                    ios6:{
                        title:"iOS 6",
                        thumbnail:"components/com_mobilize/assets/images/thumbnail/ios6.jpg",
                        style:{
                            'jsn_menu':'[{"key":"jsn_menu_container_bo_borderThickness","value":"2"},{"key":"jsn_menu_container_bo_borderStyle","value":"solid"},{"key":"jsn_menu_container_bo_borderColor","value":"#3f5c80"},{"key":"jsn_menu_container_ba_backgroundType","value":"Gradient"},{"key":"jsn_menu_container_ba_soildColor","value":"#4c85bf"},{"key":"jsn_menu_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #bdcadc 0%, #5a7598 100%)"},{"key":"jsn_menu_container_ba_activeColor","value":"#386894"},{"key":"jsn_menu_container_ic_iconColor","value":"#ffffff"},{"key":"jsn_menu_sublevel1_bo_sublevel1_bo_borderThickness","value":"1"},{"key":"jsn_menu_sublevel1_bo_sublevel1_bo_borderStyle","value":"solid"},{"key":"jsn_menu_sublevel1_bo_sublevel1_bo_borderColor","value":"#e2e2e2"},{"key":"jsn_menu_sublevel1_ba_normalColor","value":"#ffffff"},{"key":"jsn_menu_sublevel1_ba_activeColor","value":"#e5e5e5"},{"value":""},{"value":""},{"key":"jsn_menu_sublevel1_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_menu_sublevel1_fo_fontFace","value":"Open Sans"},{"key":"jsn_menu_sublevel1_fo_fontSize","value":""},{"key":"jsn_menu_sublevel1_fo_fontStyle","value":"inherit"},{"key":"jsn_menu_sublevel1_fo_fontColor","value":"#292929"},{"key":"jsn_menu_sublevel2_ba_normalColor","value":"#ffffff"},{"value":""},{"value":""},{"key":"jsn_menu_sublevel2_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_menu_sublevel2_fo_fontFace","value":"Open Sans"},{"key":"jsn_menu_sublevel2_fo_fontSize","value":""},{"key":"jsn_menu_sublevel2_fo_fontStyle","value":"inherit"},{"key":"jsn_menu_sublevel2_fo_fontColor","value":"#292929"}]',
                            'jsn_logo':'[{"key":"jsn_logo_container_bo_borderThickness","value":""},{"key":"jsn_logo_container_bo_borderStyle","value":"solid"},{"key":"jsn_logo_container_bo_borderColor","value":"#ffffff"},{"key":"jsn_logo_container_ba_backgroundType","value":"Solid"},{"key":"jsn_logo_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_logo_container_ba_gradientColor","value":"-moz-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_logo_container_sp_paddingleft","value":"10"},{"key":"jsn_logo_container_sp_paddingright","value":"10"},{"key":"jsn_logo_container_sp_paddingbottom","value":"10"},{"key":"jsn_logo_container_sp_paddingtop","value":"10"},{"key":"jsn_logo_content_alignment","value":"center"}]',
                            'jsn_mobile_tool':'[{"key":"jsn_mobile_tool_container_bo_borderThickness","value":""},{"key":"jsn_mobile_tool_container_bo_borderStyle","value":"solid"},{"key":"jsn_mobile_tool_container_bo_borderColor","value":"#ffffff"},{"key":"jsn_mobile_tool_container_ba_backgroundType","value":"Solid"},{"key":"jsn_mobile_tool_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_mobile_tool_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #162330 0%, #283317 47%, #2e0c30 100%)"},{"key":"jsn_mobile_tool_container_sp_paddingleft","value":""},{"key":"jsn_mobile_tool_container_sp_paddingright","value":""},{"key":"jsn_mobile_tool_container_sp_paddingbottom","value":""},{"key":"jsn_mobile_tool_container_sp_paddingtop","value":""},{"key":"jsn_mobile_tool_module_tabContainer_bo_borderThickness","value":"0"},{"key":"jsn_mobile_tool_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_mobile_tool_module_tabContainer_bo_borderColor","value":"#ededed"},{"key":"jsn_mobile_tool_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_mobile_tool_module_tabContainer_ba_soildColor","value":"#ffffff"},{"key":"jsn_mobile_tool_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #f5f5f5 0%, #e8e8e8 100%)"},{"key":"jsn_mobile_tool_module_tabContainer_bo_roundedCornerRadius","value":"10"},{"key":"jsn_mobile_tool_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_mobile_tool_module_tabContainer_sh_shadowColor","value":"#ffffff"},{"key":"jsn_mobile_tool_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_mobile_tool_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_mobile_tool_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_mobile_tool_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_mobile_tool_module_tabContainer_sp_paddingleft","value":"15"},{"key":"jsn_mobile_tool_module_tabContainer_sp_paddingright","value":"15"},{"key":"jsn_mobile_tool_module_tabContainer_sp_paddingbottom","value":"10"},{"key":"jsn_mobile_tool_module_tabContainer_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontFace","value":"Open Sans"},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontSize","value":"18"},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontColor","value":"#000000"},{"value":""},{"value":""},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontFace","value":"Open Sans"},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontSize","value":""},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontColor","value":"#000000"},{"key":"jsn_mobile_tool_module_tabContent_link_linkColor","value":""}]',
                            'jsn_content_top':'[{"key":"jsn_content_top_container_bo_borderThickness","value":""},{"key":"jsn_content_top_container_bo_borderStyle","value":"solid"},{"key":"jsn_content_top_container_bo_borderColor","value":""},{"key":"jsn_content_top_container_ba_backgroundType","value":"Solid"},{"key":"jsn_content_top_container_ba_soildColor","value":"#4f5971"},{"key":"jsn_content_top_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #cbdef2 0%, #f0e8ef 47%, #e1f7ec 100%)"},{"key":"jsn_content_top_container_sp_paddingleft","value":""},{"key":"jsn_content_top_container_sp_paddingright","value":""},{"key":"jsn_content_top_container_sp_paddingbottom","value":""},{"key":"jsn_content_top_container_sp_paddingtop","value":""},{"key":"jsn_content_top_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_content_top_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_content_top_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_content_top_module_tabContainer_ba_backgroundType","value":"Gradient"},{"key":"jsn_content_top_module_tabContainer_ba_soildColor","value":"#facd52"},{"key":"jsn_content_top_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #fcfcfc 0%, #f2f2f2 1%, #f0f0f0 98%, #ffffff 100%)"},{"key":"jsn_content_top_module_tabContainer_bo_roundedCornerRadius","value":"5"},{"key":"jsn_content_top_module_tabContainer_sh_shadowSpread","value":"2"},{"key":"jsn_content_top_module_tabContainer_sh_shadowColor","value":"#202930"},{"key":"jsn_content_top_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_content_top_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_content_top_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_content_top_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_content_top_module_tabContainer_sp_paddingleft","value":"15"},{"key":"jsn_content_top_module_tabContainer_sp_paddingright","value":"15"},{"key":"jsn_content_top_module_tabContainer_sp_paddingbottom","value":"10"},{"key":"jsn_content_top_module_tabContainer_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_content_top_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_content_top_module_tabContent_title_fo_fontFace","value":"Open Sans"},{"key":"jsn_content_top_module_tabContent_title_fo_fontSize","value":"18"},{"key":"jsn_content_top_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_content_top_module_tabContent_title_fo_fontColor","value":"#000000"},{"value":""},{"value":""},{"key":"jsn_content_top_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_content_top_module_tabContent_body_fo_fontFace","value":"Open Sans"},{"key":"jsn_content_top_module_tabContent_body_fo_fontSize","value":""},{"key":"jsn_content_top_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_content_top_module_tabContent_body_fo_fontColor","value":"#6b6b6b"},{"key":"jsn_content_top_module_tabContent_link_linkColor","value":""}]',
                            'jsn_user_top':'[{"key":"jsn_user_top_container_bo_borderThickness","value":""},{"key":"jsn_user_top_container_bo_borderStyle","value":"solid"},{"key":"jsn_user_top_container_bo_borderColor","value":""},{"key":"jsn_user_top_container_ba_backgroundType","value":"Solid"},{"key":"jsn_user_top_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_user_top_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_user_top_container_sp_paddingleft","value":""},{"key":"jsn_user_top_container_sp_paddingright","value":""},{"key":"jsn_user_top_container_sp_paddingbottom","value":""},{"key":"jsn_user_top_container_sp_paddingtop","value":""},{"key":"jsn_user_top_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_user_top_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_user_top_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_user_top_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_user_top_module_tabContainer_ba_soildColor","value":"#ffffff"},{"key":"jsn_user_top_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #301921 0%, #19162b 100%)"},{"key":"jsn_user_top_module_tabContainer_bo_roundedCornerRadius","value":"5"},{"key":"jsn_user_top_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_user_top_module_tabContainer_sh_shadowColor","value":""},{"key":"jsn_user_top_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_user_top_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_user_top_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_user_top_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_user_top_module_tabContainer_sp_paddingleft","value":"15"},{"key":"jsn_user_top_module_tabContainer_sp_paddingright","value":"15"},{"key":"jsn_user_top_module_tabContainer_sp_paddingbottom","value":"10"},{"key":"jsn_user_top_module_tabContainer_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_user_top_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_user_top_module_tabContent_title_fo_fontFace","value":"Open Sans"},{"key":"jsn_user_top_module_tabContent_title_fo_fontSize","value":"18"},{"key":"jsn_user_top_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_user_top_module_tabContent_title_fo_fontColor","value":"#262626"},{"value":""},{"value":""},{"key":"jsn_user_top_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_user_top_module_tabContent_body_fo_fontFace","value":"Open Sans"},{"key":"jsn_user_top_module_tabContent_body_fo_fontSize","value":""},{"key":"jsn_user_top_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_user_top_module_tabContent_body_fo_fontColor","value":"#262626"},{"key":"jsn_user_top_module_tabContent_link_linkColor","value":"#000000"}]',
                            'jsn_mainbody':'[{"key":"jsn_mainbody_container_bo_borderThickness","value":""},{"key":"jsn_mainbody_container_bo_borderStyle","value":"dotted"},{"key":"jsn_mainbody_container_bo_borderColor","value":"#ffffff"},{"key":"jsn_mainbody_container_ba_backgroundType","value":"Solid"},{"key":"jsn_mainbody_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_mainbody_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_mainbody_container_sh_shadowSpread","value":""},{"key":"jsn_mainbody_container_sh_shadowColor","value":"#ffffff"},{"key":"jsn_mainbody_container_bo_roundedCornerRadius","value":""},{"key":"jsn_mainbody_container_sp_paddingleft","value":"20"},{"key":"jsn_mainbody_container_sp_paddingright","value":"20"},{"key":"jsn_mainbody_container_sp_paddingbottom","value":"10"},{"key":"jsn_mainbody_container_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_mainbody_content_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_mainbody_content_title_fo_fontFace","value":"Lato"},{"key":"jsn_mainbody_content_title_fo_fontSize","value":"24"},{"key":"jsn_mainbody_content_title_fo_fontStyle","value":"inherit"},{"key":"jsn_mainbody_content_title_fo_fontColor","value":"#2195cf"},{"value":""},{"value":""},{"key":"jsn_mainbody_content_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_mainbody_content_body_fo_fontFace","value":"Open Sans"},{"key":"jsn_mainbody_content_body_fo_fontSize","value":""},{"key":"jsn_mainbody_content_body_fo_fontStyle","value":"inherit"},{"key":"jsn_mainbody_content_body_fo_fontColor","value":"#333333"},{"key":"jsn_mainbody_content_link_linkColor","value":""}]',
                            'jsn_user_bottom':'[{"key":"jsn_user_bottom_container_bo_borderThickness","value":""},{"key":"jsn_user_bottom_container_bo_borderStyle","value":"solid"},{"key":"jsn_user_bottom_container_bo_borderColor","value":""},{"key":"jsn_user_bottom_container_ba_backgroundType","value":"Solid"},{"key":"jsn_user_bottom_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_user_bottom_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #d2e7f5 0%, #e8dcdf 49%, #e5edd3 100%)"},{"key":"jsn_user_bottom_container_sp_paddingleft","value":"20"},{"key":"jsn_user_bottom_container_sp_paddingright","value":"20"},{"key":"jsn_user_bottom_container_sp_paddingbottom","value":"10"},{"key":"jsn_user_bottom_container_sp_paddingtop","value":"10"},{"key":"jsn_user_bottom_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_user_bottom_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_user_bottom_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_user_bottom_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_user_bottom_module_tabContainer_ba_soildColor","value":"#ffffff"},{"key":"jsn_user_bottom_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_user_bottom_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_user_bottom_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_user_bottom_module_tabContainer_sh_shadowColor","value":""},{"key":"jsn_user_bottom_module_tabContainer_sp_marginleft","value":""},{"key":"jsn_user_bottom_module_tabContainer_sp_marginright","value":""},{"key":"jsn_user_bottom_module_tabContainer_sp_marginbottom","value":""},{"key":"jsn_user_bottom_module_tabContainer_sp_margintop","value":""},{"key":"jsn_user_bottom_module_tabContainer_sp_paddingleft","value":""},{"key":"jsn_user_bottom_module_tabContainer_sp_paddingright","value":""},{"key":"jsn_user_bottom_module_tabContainer_sp_paddingbottom","value":""},{"key":"jsn_user_bottom_module_tabContainer_sp_paddingtop","value":""},{"value":""},{"value":""},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontFace","value":"Verdana"},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontSize","value":"18"},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontColor","value":"#000000"},{"value":""},{"value":""},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontFace","value":"Verdana"},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontSize","value":""},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontColor","value":"#000000"},{"key":"jsn_user_bottom_module_tabContent_link_linkColor","value":""}]',
                            'jsn_content_bottom':'[{"key":"jsn_content_bottom_container_bo_borderThickness","value":""},{"key":"jsn_content_bottom_container_bo_borderStyle","value":"solid"},{"key":"jsn_content_bottom_container_bo_borderColor","value":""},{"key":"jsn_content_bottom_container_ba_backgroundType","value":"Solid"},{"key":"jsn_content_bottom_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_content_bottom_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #e6e6e6 0%, #ffffff 46%, #ededed 100%)"},{"key":"jsn_content_bottom_container_sp_paddingleft","value":""},{"key":"jsn_content_bottom_container_sp_paddingright","value":""},{"key":"jsn_content_bottom_container_sp_paddingbottom","value":""},{"key":"jsn_content_bottom_container_sp_paddingtop","value":""},{"key":"jsn_content_bottom_module_tabContainer_bo_borderThickness","value":"1"},{"key":"jsn_content_bottom_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_content_bottom_module_tabContainer_bo_borderColor","value":"#365174"},{"key":"jsn_content_bottom_module_tabContainer_ba_backgroundType","value":"Gradient"},{"key":"jsn_content_bottom_module_tabContainer_ba_soildColor","value":"#dedede"},{"key":"jsn_content_bottom_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #8197b3 0%, #375175 100%)"},{"key":"jsn_content_bottom_module_tabContainer_bo_roundedCornerRadius","value":"5"},{"key":"jsn_content_bottom_module_tabContainer_sh_shadowSpread","value":"2"},{"key":"jsn_content_bottom_module_tabContainer_sh_shadowColor","value":"#dedede"},{"key":"jsn_content_bottom_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_content_bottom_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_content_bottom_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_content_bottom_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_content_bottom_module_tabContainer_sp_paddingleft","value":"15"},{"key":"jsn_content_bottom_module_tabContainer_sp_paddingright","value":"15"},{"key":"jsn_content_bottom_module_tabContainer_sp_paddingbottom","value":"10"},{"key":"jsn_content_bottom_module_tabContainer_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontFace","value":"Open Sans"},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontSize","value":"18"},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontColor","value":"#ffffff"},{"value":""},{"value":""},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontFace","value":"Open Sans"},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontSize","value":""},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontColor","value":"#ffffff"},{"key":"jsn_content_bottom_module_tabContent_link_linkColor","value":"#b7daf7"}]',
                            'jsn_footer':'[{"key":"jsn_footer_container_bo_borderThickness","value":""},{"key":"jsn_footer_container_bo_borderStyle","value":"solid"},{"key":"jsn_footer_container_bo_borderColor","value":""},{"key":"jsn_footer_container_ba_backgroundType","value":"Gradient"},{"key":"jsn_footer_container_ba_soildColor","value":"#262626"},{"key":"jsn_footer_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #dde3eb 0%, #9098a3 0%, #444e5c 100%)"},{"key":"jsn_footer_container_sp_paddingleft","value":""},{"key":"jsn_footer_container_sp_paddingright","value":""},{"key":"jsn_footer_container_sp_paddingbottom","value":""},{"key":"jsn_footer_container_sp_paddingtop","value":""},{"key":"jsn_footer_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_footer_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_footer_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_footer_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_footer_module_tabContainer_ba_soildColor","value":""},{"key":"jsn_footer_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_footer_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_footer_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_footer_module_tabContainer_sh_shadowColor","value":""},{"key":"jsn_footer_module_tabContainer_sp_marginleft","value":""},{"key":"jsn_footer_module_tabContainer_sp_marginright","value":""},{"key":"jsn_footer_module_tabContainer_sp_marginbottom","value":""},{"key":"jsn_footer_module_tabContainer_sp_margintop","value":""},{"key":"jsn_footer_module_tabContainer_sp_paddingleft","value":""},{"key":"jsn_footer_module_tabContainer_sp_paddingright","value":""},{"key":"jsn_footer_module_tabContainer_sp_paddingbottom","value":""},{"key":"jsn_footer_module_tabContainer_sp_paddingtop","value":""},{"value":""},{"value":""},{"key":"jsn_footer_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_footer_module_tabContent_title_fo_fontFace","value":"Open Sans"},{"key":"jsn_footer_module_tabContent_title_fo_fontSize","value":"18"},{"key":"jsn_footer_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_footer_module_tabContent_title_fo_fontColor","value":"#ffffff"},{"value":""},{"value":""},{"key":"jsn_footer_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_footer_module_tabContent_body_fo_fontFace","value":"Open Sans"},{"key":"jsn_footer_module_tabContent_body_fo_fontSize","value":""},{"key":"jsn_footer_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_footer_module_tabContent_body_fo_fontColor","value":"#ffffff"},{"key":"jsn_footer_module_tabContent_link_linkColor","value":"#c6e0f2"}]',
                            'jsn_switcher':'[{"key":"jsn_switcher_container_bo_borderThickness","value":"1"},{"key":"jsn_switcher_container_bo_borderStyle","value":"solid"},{"key":"jsn_switcher_container_bo_borderColor","value":"#55667d"},{"key":"jsn_switcher_container_ba_backgroundType","value":"Solid"},{"key":"jsn_switcher_container_ba_soildColor","value":"#444e5c"},{"key":"jsn_switcher_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_switcher_container_sp_paddingleft","value":""},{"key":"jsn_switcher_container_sp_paddingright","value":""},{"key":"jsn_switcher_container_sp_paddingbottom","value":"10"},{"key":"jsn_switcher_container_sp_paddingtop","value":"10"}]'
                        }
                    },
                    ios7:{
                        title:"iOS 7",
                        thumbnail:"components/com_mobilize/assets/images/thumbnail/ios7.jpg",
                        style:{
                            'jsn_menu':'[{"key":"jsn_menu_container_bo_borderThickness","value":""},{"key":"jsn_menu_container_bo_borderStyle","value":"dotted"},{"key":"jsn_menu_container_bo_borderColor","value":"#ffffff"},{"key":"jsn_menu_container_ba_backgroundType","value":"Solid"},{"key":"jsn_menu_container_ba_soildColor","value":"#121212"},{"key":"jsn_menu_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_menu_container_ba_activeColor","value":"#474747"},{"key":"jsn_menu_container_ic_iconColor","value":"#ffffff"},{"key":"jsn_menu_sublevel1_bo_sublevel1_bo_borderThickness","value":""},{"key":"jsn_menu_sublevel1_bo_sublevel1_bo_borderStyle","value":"solid"},{"key":"jsn_menu_sublevel1_bo_sublevel1_bo_borderColor","value":"#ffffff"},{"key":"jsn_menu_sublevel1_ba_normalColor","value":"#333333"},{"key":"jsn_menu_sublevel1_ba_activeColor","value":"#43b2d1"},{"value":""},{"value":""},{"key":"jsn_menu_sublevel1_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_menu_sublevel1_fo_fontFace","value":"Verdana"},{"key":"jsn_menu_sublevel1_fo_fontSize","value":""},{"key":"jsn_menu_sublevel1_fo_fontStyle","value":"inherit"},{"key":"jsn_menu_sublevel1_fo_fontColor","value":"#ffffff"},{"key":"jsn_menu_sublevel2_ba_normalColor","value":"#212121"},{"value":""},{"value":""},{"key":"jsn_menu_sublevel2_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_menu_sublevel2_fo_fontFace","value":"Verdana"},{"key":"jsn_menu_sublevel2_fo_fontSize","value":""},{"key":"jsn_menu_sublevel2_fo_fontStyle","value":"inherit"},{"key":"jsn_menu_sublevel2_fo_fontColor","value":"#ffffff"}]',
                            'jsn_logo':'[{"key":"jsn_logo_container_bo_borderThickness","value":""},{"key":"jsn_logo_container_bo_borderStyle","value":"solid"},{"key":"jsn_logo_container_bo_borderColor","value":"#ffffff"},{"key":"jsn_logo_container_ba_backgroundType","value":"Solid"},{"key":"jsn_logo_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_logo_container_ba_gradientColor","value":"-moz-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_logo_container_sp_paddingleft","value":"10"},{"key":"jsn_logo_container_sp_paddingright","value":"10"},{"key":"jsn_logo_container_sp_paddingbottom","value":"10"},{"key":"jsn_logo_container_sp_paddingtop","value":"10"},{"key":"jsn_logo_content_alignment","value":"center"}]',
                            'jsn_mobile_tool':'[{"key":"jsn_mobile_tool_container_bo_borderThickness","value":"0"},{"key":"jsn_mobile_tool_container_bo_borderStyle","value":"solid"},{"key":"jsn_mobile_tool_container_bo_borderColor","value":"#ffffff"},{"key":"jsn_mobile_tool_container_ba_backgroundType","value":"Solid"},{"key":"jsn_mobile_tool_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_mobile_tool_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_mobile_tool_container_sp_paddingleft","value":""},{"key":"jsn_mobile_tool_container_sp_paddingright","value":""},{"key":"jsn_mobile_tool_container_sp_paddingbottom","value":""},{"key":"jsn_mobile_tool_container_sp_paddingtop","value":""},{"key":"jsn_mobile_tool_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_mobile_tool_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_mobile_tool_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_mobile_tool_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_mobile_tool_module_tabContainer_ba_soildColor","value":"#ed3447"},{"key":"jsn_mobile_tool_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_mobile_tool_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_mobile_tool_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_mobile_tool_module_tabContainer_sh_shadowColor","value":"#ffffff"},{"key":"jsn_mobile_tool_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_mobile_tool_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_mobile_tool_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_mobile_tool_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_mobile_tool_module_tabContainer_sp_paddingleft","value":"15"},{"key":"jsn_mobile_tool_module_tabContainer_sp_paddingright","value":"15"},{"key":"jsn_mobile_tool_module_tabContainer_sp_paddingbottom","value":"10"},{"key":"jsn_mobile_tool_module_tabContainer_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontFace","value":"PT Sans"},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontSize","value":"15"},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontColor","value":"#ffffff"},{"value":""},{"value":""},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontFace","value":"PT Sans"},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontSize","value":"13"},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontColor","value":"#ffffff"},{"key":"jsn_mobile_tool_module_tabContent_link_linkColor","value":"#eeeeee"}]',
                            'jsn_content_top':'[{"key":"jsn_content_top_container_bo_borderThickness","value":""},{"key":"jsn_content_top_container_bo_borderStyle","value":"solid"},{"key":"jsn_content_top_container_bo_borderColor","value":""},{"key":"jsn_content_top_container_ba_backgroundType","value":"Solid"},{"key":"jsn_content_top_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_content_top_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_content_top_container_sp_paddingleft","value":""},{"key":"jsn_content_top_container_sp_paddingright","value":""},{"key":"jsn_content_top_container_sp_paddingbottom","value":""},{"key":"jsn_content_top_container_sp_paddingtop","value":""},{"key":"jsn_content_top_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_content_top_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_content_top_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_content_top_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_content_top_module_tabContainer_ba_soildColor","value":"#3e8ede"},{"key":"jsn_content_top_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_content_top_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_content_top_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_content_top_module_tabContainer_sh_shadowColor","value":""},{"key":"jsn_content_top_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_content_top_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_content_top_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_content_top_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_content_top_module_tabContainer_sp_paddingleft","value":"15"},{"key":"jsn_content_top_module_tabContainer_sp_paddingright","value":"15"},{"key":"jsn_content_top_module_tabContainer_sp_paddingbottom","value":"10"},{"key":"jsn_content_top_module_tabContainer_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_content_top_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_content_top_module_tabContent_title_fo_fontFace","value":"PT Sans"},{"key":"jsn_content_top_module_tabContent_title_fo_fontSize","value":"15"},{"key":"jsn_content_top_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_content_top_module_tabContent_title_fo_fontColor","value":"#ffffff"},{"value":""},{"value":""},{"key":"jsn_content_top_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_content_top_module_tabContent_body_fo_fontFace","value":"PT Sans"},{"key":"jsn_content_top_module_tabContent_body_fo_fontSize","value":"13"},{"key":"jsn_content_top_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_content_top_module_tabContent_body_fo_fontColor","value":"#ffffff"},{"key":"jsn_content_top_module_tabContent_link_linkColor","value":"#eeeeee"}]',
                            'jsn_user_top':'[{"key":"jsn_user_top_container_bo_borderThickness","value":""},{"key":"jsn_user_top_container_bo_borderStyle","value":"solid"},{"key":"jsn_user_top_container_bo_borderColor","value":""},{"key":"jsn_user_top_container_ba_backgroundType","value":"Solid"},{"key":"jsn_user_top_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_user_top_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_user_top_container_sp_paddingleft","value":""},{"key":"jsn_user_top_container_sp_paddingright","value":""},{"key":"jsn_user_top_container_sp_paddingbottom","value":""},{"key":"jsn_user_top_container_sp_paddingtop","value":""},{"key":"jsn_user_top_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_user_top_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_user_top_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_user_top_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_user_top_module_tabContainer_ba_soildColor","value":"#f5b236"},{"key":"jsn_user_top_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_user_top_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_user_top_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_user_top_module_tabContainer_sh_shadowColor","value":""},{"key":"jsn_user_top_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_user_top_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_user_top_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_user_top_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_user_top_module_tabContainer_sp_paddingleft","value":"15"},{"key":"jsn_user_top_module_tabContainer_sp_paddingright","value":"15"},{"key":"jsn_user_top_module_tabContainer_sp_paddingbottom","value":"10"},{"key":"jsn_user_top_module_tabContainer_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_user_top_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_user_top_module_tabContent_title_fo_fontFace","value":"PT Sans"},{"key":"jsn_user_top_module_tabContent_title_fo_fontSize","value":"15"},{"key":"jsn_user_top_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_user_top_module_tabContent_title_fo_fontColor","value":"#333333"},{"value":""},{"value":""},{"key":"jsn_user_top_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_user_top_module_tabContent_body_fo_fontFace","value":"PT Sans"},{"key":"jsn_user_top_module_tabContent_body_fo_fontSize","value":"13"},{"key":"jsn_user_top_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_user_top_module_tabContent_body_fo_fontColor","value":"#333333"},{"key":"jsn_user_top_module_tabContent_link_linkColor","value":"#424242"}]',
                            'jsn_mainbody':'[{"key":"jsn_mainbody_container_bo_borderThickness","value":""},{"key":"jsn_mainbody_container_bo_borderStyle","value":"dotted"},{"key":"jsn_mainbody_container_bo_borderColor","value":"#ffffff"},{"key":"jsn_mainbody_container_ba_backgroundType","value":"Solid"},{"key":"jsn_mainbody_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_mainbody_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_mainbody_container_sh_shadowSpread","value":""},{"key":"jsn_mainbody_container_sh_shadowColor","value":"#ffffff"},{"key":"jsn_mainbody_container_bo_roundedCornerRadius","value":""},{"key":"jsn_mainbody_container_sp_paddingleft","value":"20"},{"key":"jsn_mainbody_container_sp_paddingright","value":"20"},{"key":"jsn_mainbody_container_sp_paddingbottom","value":"10"},{"key":"jsn_mainbody_container_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_mainbody_content_title_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_mainbody_content_title_fo_fontFace","value":"Verdana"},{"key":"jsn_mainbody_content_title_fo_fontSize","value":"18"},{"key":"jsn_mainbody_content_title_fo_fontStyle","value":"inherit"},{"key":"jsn_mainbody_content_title_fo_fontColor","value":"#000000"},{"value":""},{"value":""},{"key":"jsn_mainbody_content_body_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_mainbody_content_body_fo_fontFace","value":"Verdana"},{"key":"jsn_mainbody_content_body_fo_fontSize","value":""},{"key":"jsn_mainbody_content_body_fo_fontStyle","value":"inherit"},{"key":"jsn_mainbody_content_body_fo_fontColor","value":"#000000"},{"key":"jsn_mainbody_content_link_linkColor","value":""}]',
                            'jsn_user_bottom':'[{"key":"jsn_user_bottom_container_bo_borderThickness","value":""},{"key":"jsn_user_bottom_container_bo_borderStyle","value":"solid"},{"key":"jsn_user_bottom_container_bo_borderColor","value":""},{"key":"jsn_user_bottom_container_ba_backgroundType","value":"Solid"},{"key":"jsn_user_bottom_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_user_bottom_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_user_bottom_container_sp_paddingleft","value":""},{"key":"jsn_user_bottom_container_sp_paddingright","value":""},{"key":"jsn_user_bottom_container_sp_paddingbottom","value":""},{"key":"jsn_user_bottom_container_sp_paddingtop","value":""},{"key":"jsn_user_bottom_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_user_bottom_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_user_bottom_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_user_bottom_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_user_bottom_module_tabContainer_ba_soildColor","value":"#41961c"},{"key":"jsn_user_bottom_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_user_bottom_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_user_bottom_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_user_bottom_module_tabContainer_sh_shadowColor","value":""},{"key":"jsn_user_bottom_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_user_bottom_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_user_bottom_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_user_bottom_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_user_bottom_module_tabContainer_sp_paddingleft","value":"15"},{"key":"jsn_user_bottom_module_tabContainer_sp_paddingright","value":"15"},{"key":"jsn_user_bottom_module_tabContainer_sp_paddingbottom","value":"10"},{"key":"jsn_user_bottom_module_tabContainer_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontFace","value":"PT Sans"},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontSize","value":"15"},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontColor","value":"#ffffff"},{"value":""},{"value":""},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontFace","value":"PT Sans"},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontSize","value":"13"},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontColor","value":"#ffffff"},{"key":"jsn_user_bottom_module_tabContent_link_linkColor","value":"#eeeeee"}]',
                            'jsn_content_bottom':'[{"key":"jsn_content_bottom_container_bo_borderThickness","value":""},{"key":"jsn_content_bottom_container_bo_borderStyle","value":"solid"},{"key":"jsn_content_bottom_container_bo_borderColor","value":""},{"key":"jsn_content_bottom_container_ba_backgroundType","value":"Solid"},{"key":"jsn_content_bottom_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_content_bottom_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_content_bottom_container_sp_paddingleft","value":""},{"key":"jsn_content_bottom_container_sp_paddingright","value":""},{"key":"jsn_content_bottom_container_sp_paddingbottom","value":""},{"key":"jsn_content_bottom_container_sp_paddingtop","value":""},{"key":"jsn_content_bottom_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_content_bottom_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_content_bottom_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_content_bottom_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_content_bottom_module_tabContainer_ba_soildColor","value":"#ff5f29"},{"key":"jsn_content_bottom_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_content_bottom_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_content_bottom_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_content_bottom_module_tabContainer_sh_shadowColor","value":""},{"key":"jsn_content_bottom_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_content_bottom_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_content_bottom_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_content_bottom_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_content_bottom_module_tabContainer_sp_paddingleft","value":"15"},{"key":"jsn_content_bottom_module_tabContainer_sp_paddingright","value":"15"},{"key":"jsn_content_bottom_module_tabContainer_sp_paddingbottom","value":"10"},{"key":"jsn_content_bottom_module_tabContainer_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontFace","value":"PT Sans"},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontSize","value":"15"},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontColor","value":"#ffffff"},{"value":""},{"value":""},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontFace","value":"PT Sans"},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontSize","value":"13"},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontColor","value":"#ffffff"},{"key":"jsn_content_bottom_module_tabContent_link_linkColor","value":"#eeeeee"}]',
                            'jsn_footer':'[{"key":"jsn_footer_container_bo_borderThickness","value":""},{"key":"jsn_footer_container_bo_borderStyle","value":"solid"},{"key":"jsn_footer_container_bo_borderColor","value":""},{"key":"jsn_footer_container_ba_backgroundType","value":"Solid"},{"key":"jsn_footer_container_ba_soildColor","value":"#000000"},{"key":"jsn_footer_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_footer_container_sp_paddingleft","value":""},{"key":"jsn_footer_container_sp_paddingright","value":""},{"key":"jsn_footer_container_sp_paddingbottom","value":""},{"key":"jsn_footer_container_sp_paddingtop","value":""},{"key":"jsn_footer_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_footer_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_footer_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_footer_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_footer_module_tabContainer_ba_soildColor","value":"#000000"},{"key":"jsn_footer_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_footer_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_footer_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_footer_module_tabContainer_sh_shadowColor","value":""},{"key":"jsn_footer_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_footer_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_footer_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_footer_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_footer_module_tabContainer_sp_paddingleft","value":""},{"key":"jsn_footer_module_tabContainer_sp_paddingright","value":""},{"key":"jsn_footer_module_tabContainer_sp_paddingbottom","value":""},{"key":"jsn_footer_module_tabContainer_sp_paddingtop","value":""},{"value":""},{"value":""},{"key":"jsn_footer_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_footer_module_tabContent_title_fo_fontFace","value":"PT Sans"},{"key":"jsn_footer_module_tabContent_title_fo_fontSize","value":"15"},{"key":"jsn_footer_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_footer_module_tabContent_title_fo_fontColor","value":"#ffffff"},{"value":""},{"value":""},{"key":"jsn_footer_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_footer_module_tabContent_body_fo_fontFace","value":"PT Sans"},{"key":"jsn_footer_module_tabContent_body_fo_fontSize","value":"13"},{"key":"jsn_footer_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_footer_module_tabContent_body_fo_fontColor","value":"#ffffff"},{"key":"jsn_footer_module_tabContent_link_linkColor","value":"#eeeeee"}]',
                            'jsn_switcher':'[{"key":"jsn_switcher_container_bo_borderThickness","value":"1"},{"key":"jsn_switcher_container_bo_borderStyle","value":"solid"},{"key":"jsn_switcher_container_bo_borderColor","value":"#2e2e2e"},{"key":"jsn_switcher_container_ba_backgroundType","value":"Solid"},{"key":"jsn_switcher_container_ba_soildColor","value":"#121212"},{"key":"jsn_switcher_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_switcher_container_sp_paddingleft","value":""},{"key":"jsn_switcher_container_sp_paddingright","value":""},{"key":"jsn_switcher_container_sp_paddingbottom","value":"10"},{"key":"jsn_switcher_container_sp_paddingtop","value":"10"}]'
                        }
                    },
                    windowsphone:{
                        title:"Windows Mobile",
                        thumbnail:"components/com_mobilize/assets/images/thumbnail/windows-mobile.jpg",
                        style:{
                            'jsn_menu':'[{"key":"jsn_menu_container_bo_borderThickness","value":""},{"key":"jsn_menu_container_bo_borderStyle","value":"dotted"},{"key":"jsn_menu_container_bo_borderColor","value":"#ffffff"},{"key":"jsn_menu_container_ba_backgroundType","value":"Solid"},{"key":"jsn_menu_container_ba_soildColor","value":"#121212"},{"key":"jsn_menu_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_menu_container_ba_activeColor","value":"#474747"},{"key":"jsn_menu_container_ic_iconColor","value":"#ffffff"},{"key":"jsn_menu_sublevel1_bo_sublevel1_bo_borderThickness","value":""},{"key":"jsn_menu_sublevel1_bo_sublevel1_bo_borderStyle","value":"solid"},{"key":"jsn_menu_sublevel1_bo_sublevel1_bo_borderColor","value":"#ffffff"},{"key":"jsn_menu_sublevel1_ba_normalColor","value":"#333333"},{"key":"jsn_menu_sublevel1_ba_activeColor","value":"#43b2d1"},{"value":""},{"value":""},{"key":"jsn_menu_sublevel1_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_menu_sublevel1_fo_fontFace","value":"Verdana"},{"key":"jsn_menu_sublevel1_fo_fontSize","value":""},{"key":"jsn_menu_sublevel1_fo_fontStyle","value":"inherit"},{"key":"jsn_menu_sublevel1_fo_fontColor","value":"#ffffff"},{"key":"jsn_menu_sublevel2_ba_normalColor","value":"#212121"},{"value":""},{"value":""},{"key":"jsn_menu_sublevel2_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_menu_sublevel2_fo_fontFace","value":"Verdana"},{"key":"jsn_menu_sublevel2_fo_fontSize","value":""},{"key":"jsn_menu_sublevel2_fo_fontStyle","value":"inherit"},{"key":"jsn_menu_sublevel2_fo_fontColor","value":"#ffffff"}]',
                            'jsn_logo':'[{"key":"jsn_logo_container_bo_borderThickness","value":""},{"key":"jsn_logo_container_bo_borderStyle","value":"solid"},{"key":"jsn_logo_container_bo_borderColor","value":"#ffffff"},{"key":"jsn_logo_container_ba_backgroundType","value":"Solid"},{"key":"jsn_logo_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_logo_container_ba_gradientColor","value":"-moz-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_logo_container_sp_paddingleft","value":"10"},{"key":"jsn_logo_container_sp_paddingright","value":"10"},{"key":"jsn_logo_container_sp_paddingbottom","value":"10"},{"key":"jsn_logo_container_sp_paddingtop","value":"10"},{"key":"jsn_logo_content_alignment","value":"center"}]',
                            'jsn_mobile_tool':'[{"key":"jsn_mobile_tool_container_bo_borderThickness","value":"0"},{"key":"jsn_mobile_tool_container_bo_borderStyle","value":"solid"},{"key":"jsn_mobile_tool_container_bo_borderColor","value":"#ffffff"},{"key":"jsn_mobile_tool_container_ba_backgroundType","value":"Solid"},{"key":"jsn_mobile_tool_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_mobile_tool_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_mobile_tool_container_sp_paddingleft","value":""},{"key":"jsn_mobile_tool_container_sp_paddingright","value":""},{"key":"jsn_mobile_tool_container_sp_paddingbottom","value":""},{"key":"jsn_mobile_tool_container_sp_paddingtop","value":""},{"key":"jsn_mobile_tool_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_mobile_tool_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_mobile_tool_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_mobile_tool_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_mobile_tool_module_tabContainer_ba_soildColor","value":"#ed3447"},{"key":"jsn_mobile_tool_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_mobile_tool_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_mobile_tool_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_mobile_tool_module_tabContainer_sh_shadowColor","value":"#ffffff"},{"key":"jsn_mobile_tool_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_mobile_tool_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_mobile_tool_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_mobile_tool_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_mobile_tool_module_tabContainer_sp_paddingleft","value":"15"},{"key":"jsn_mobile_tool_module_tabContainer_sp_paddingright","value":"15"},{"key":"jsn_mobile_tool_module_tabContainer_sp_paddingbottom","value":"10"},{"key":"jsn_mobile_tool_module_tabContainer_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontFace","value":"PT Sans"},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontSize","value":"16"},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontColor","value":"#ffffff"},{"value":""},{"value":""},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontFace","value":"PT Sans"},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontSize","value":"13"},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontColor","value":"#ffffff"},{"key":"jsn_mobile_tool_module_tabContent_link_linkColor","value":"#eeeeee"}]',
                            'jsn_content_top':'[{"key":"jsn_content_top_container_bo_borderThickness","value":""},{"key":"jsn_content_top_container_bo_borderStyle","value":"solid"},{"key":"jsn_content_top_container_bo_borderColor","value":""},{"key":"jsn_content_top_container_ba_backgroundType","value":"Solid"},{"key":"jsn_content_top_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_content_top_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_content_top_container_sp_paddingleft","value":""},{"key":"jsn_content_top_container_sp_paddingright","value":""},{"key":"jsn_content_top_container_sp_paddingbottom","value":""},{"key":"jsn_content_top_container_sp_paddingtop","value":""},{"key":"jsn_content_top_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_content_top_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_content_top_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_content_top_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_content_top_module_tabContainer_ba_soildColor","value":"#3e8ede"},{"key":"jsn_content_top_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_content_top_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_content_top_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_content_top_module_tabContainer_sh_shadowColor","value":""},{"key":"jsn_content_top_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_content_top_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_content_top_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_content_top_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_content_top_module_tabContainer_sp_paddingleft","value":"15"},{"key":"jsn_content_top_module_tabContainer_sp_paddingright","value":"15"},{"key":"jsn_content_top_module_tabContainer_sp_paddingbottom","value":"10"},{"key":"jsn_content_top_module_tabContainer_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_content_top_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_content_top_module_tabContent_title_fo_fontFace","value":"PT Sans"},{"key":"jsn_content_top_module_tabContent_title_fo_fontSize","value":"16"},{"key":"jsn_content_top_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_content_top_module_tabContent_title_fo_fontColor","value":"#ffffff"},{"value":""},{"value":""},{"key":"jsn_content_top_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_content_top_module_tabContent_body_fo_fontFace","value":"PT Sans"},{"key":"jsn_content_top_module_tabContent_body_fo_fontSize","value":"13"},{"key":"jsn_content_top_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_content_top_module_tabContent_body_fo_fontColor","value":"#ffffff"},{"key":"jsn_content_top_module_tabContent_link_linkColor","value":"#eeeeee"}]',
                            'jsn_user_top':'[{"key":"jsn_user_top_container_bo_borderThickness","value":""},{"key":"jsn_user_top_container_bo_borderStyle","value":"solid"},{"key":"jsn_user_top_container_bo_borderColor","value":""},{"key":"jsn_user_top_container_ba_backgroundType","value":"Solid"},{"key":"jsn_user_top_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_user_top_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_user_top_container_sp_paddingleft","value":""},{"key":"jsn_user_top_container_sp_paddingright","value":""},{"key":"jsn_user_top_container_sp_paddingbottom","value":""},{"key":"jsn_user_top_container_sp_paddingtop","value":""},{"key":"jsn_user_top_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_user_top_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_user_top_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_user_top_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_user_top_module_tabContainer_ba_soildColor","value":"#f5b236"},{"key":"jsn_user_top_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_user_top_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_user_top_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_user_top_module_tabContainer_sh_shadowColor","value":""},{"key":"jsn_user_top_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_user_top_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_user_top_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_user_top_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_user_top_module_tabContainer_sp_paddingleft","value":"15"},{"key":"jsn_user_top_module_tabContainer_sp_paddingright","value":"15"},{"key":"jsn_user_top_module_tabContainer_sp_paddingbottom","value":"10"},{"key":"jsn_user_top_module_tabContainer_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_user_top_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_user_top_module_tabContent_title_fo_fontFace","value":"PT Sans"},{"key":"jsn_user_top_module_tabContent_title_fo_fontSize","value":"16"},{"key":"jsn_user_top_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_user_top_module_tabContent_title_fo_fontColor","value":"#333333"},{"value":""},{"value":""},{"key":"jsn_user_top_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_user_top_module_tabContent_body_fo_fontFace","value":"PT Sans"},{"key":"jsn_user_top_module_tabContent_body_fo_fontSize","value":"13"},{"key":"jsn_user_top_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_user_top_module_tabContent_body_fo_fontColor","value":"#333333"},{"key":"jsn_user_top_module_tabContent_link_linkColor","value":"#424242"}]',
                            'jsn_mainbody':'[{"key":"jsn_mainbody_container_bo_borderThickness","value":""},{"key":"jsn_mainbody_container_bo_borderStyle","value":"dotted"},{"key":"jsn_mainbody_container_bo_borderColor","value":"#ffffff"},{"key":"jsn_mainbody_container_ba_backgroundType","value":"Solid"},{"key":"jsn_mainbody_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_mainbody_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_mainbody_container_sh_shadowSpread","value":""},{"key":"jsn_mainbody_container_sh_shadowColor","value":"#ffffff"},{"key":"jsn_mainbody_container_bo_roundedCornerRadius","value":""},{"key":"jsn_mainbody_container_sp_paddingleft","value":"20"},{"key":"jsn_mainbody_container_sp_paddingright","value":"20"},{"key":"jsn_mainbody_container_sp_paddingbottom","value":"10"},{"key":"jsn_mainbody_container_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_mainbody_content_title_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_mainbody_content_title_fo_fontFace","value":"Verdana"},{"key":"jsn_mainbody_content_title_fo_fontSize","value":"20"},{"key":"jsn_mainbody_content_title_fo_fontStyle","value":"inherit"},{"key":"jsn_mainbody_content_title_fo_fontColor","value":"#000000"},{"value":""},{"value":""},{"key":"jsn_mainbody_content_body_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_mainbody_content_body_fo_fontFace","value":"Verdana"},{"key":"jsn_mainbody_content_body_fo_fontSize","value":""},{"key":"jsn_mainbody_content_body_fo_fontStyle","value":"inherit"},{"key":"jsn_mainbody_content_body_fo_fontColor","value":"#000000"},{"key":"jsn_mainbody_content_link_linkColor","value":""}]',
                            'jsn_user_bottom':'[{"key":"jsn_user_bottom_container_bo_borderThickness","value":""},{"key":"jsn_user_bottom_container_bo_borderStyle","value":"solid"},{"key":"jsn_user_bottom_container_bo_borderColor","value":""},{"key":"jsn_user_bottom_container_ba_backgroundType","value":"Solid"},{"key":"jsn_user_bottom_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_user_bottom_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_user_bottom_container_sp_paddingleft","value":""},{"key":"jsn_user_bottom_container_sp_paddingright","value":""},{"key":"jsn_user_bottom_container_sp_paddingbottom","value":""},{"key":"jsn_user_bottom_container_sp_paddingtop","value":""},{"key":"jsn_user_bottom_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_user_bottom_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_user_bottom_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_user_bottom_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_user_bottom_module_tabContainer_ba_soildColor","value":"#41961c"},{"key":"jsn_user_bottom_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_user_bottom_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_user_bottom_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_user_bottom_module_tabContainer_sh_shadowColor","value":""},{"key":"jsn_user_bottom_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_user_bottom_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_user_bottom_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_user_bottom_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_user_bottom_module_tabContainer_sp_paddingleft","value":"15"},{"key":"jsn_user_bottom_module_tabContainer_sp_paddingright","value":"15"},{"key":"jsn_user_bottom_module_tabContainer_sp_paddingbottom","value":"10"},{"key":"jsn_user_bottom_module_tabContainer_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontFace","value":"PT Sans"},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontSize","value":"16"},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontColor","value":"#ffffff"},{"value":""},{"value":""},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontFace","value":"PT Sans"},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontSize","value":"13"},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontColor","value":"#ffffff"},{"key":"jsn_user_bottom_module_tabContent_link_linkColor","value":"#eeeeee"}]',
                            'jsn_content_bottom':'[{"key":"jsn_content_bottom_container_bo_borderThickness","value":""},{"key":"jsn_content_bottom_container_bo_borderStyle","value":"solid"},{"key":"jsn_content_bottom_container_bo_borderColor","value":""},{"key":"jsn_content_bottom_container_ba_backgroundType","value":"Solid"},{"key":"jsn_content_bottom_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_content_bottom_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_content_bottom_container_sp_paddingleft","value":""},{"key":"jsn_content_bottom_container_sp_paddingright","value":""},{"key":"jsn_content_bottom_container_sp_paddingbottom","value":""},{"key":"jsn_content_bottom_container_sp_paddingtop","value":""},{"key":"jsn_content_bottom_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_content_bottom_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_content_bottom_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_content_bottom_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_content_bottom_module_tabContainer_ba_soildColor","value":"#ff5f29"},{"key":"jsn_content_bottom_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_content_bottom_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_content_bottom_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_content_bottom_module_tabContainer_sh_shadowColor","value":""},{"key":"jsn_content_bottom_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_content_bottom_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_content_bottom_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_content_bottom_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_content_bottom_module_tabContainer_sp_paddingleft","value":"15"},{"key":"jsn_content_bottom_module_tabContainer_sp_paddingright","value":"15"},{"key":"jsn_content_bottom_module_tabContainer_sp_paddingbottom","value":"10"},{"key":"jsn_content_bottom_module_tabContainer_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontFace","value":"PT Sans"},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontSize","value":"16"},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontColor","value":"#ffffff"},{"value":""},{"value":""},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontFace","value":"PT Sans"},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontSize","value":"13"},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontColor","value":"#ffffff"},{"key":"jsn_content_bottom_module_tabContent_link_linkColor","value":"#eeeeee"}]',
                            'jsn_footer':'[{"key":"jsn_footer_container_bo_borderThickness","value":""},{"key":"jsn_footer_container_bo_borderStyle","value":"solid"},{"key":"jsn_footer_container_bo_borderColor","value":""},{"key":"jsn_footer_container_ba_backgroundType","value":"Solid"},{"key":"jsn_footer_container_ba_soildColor","value":"#000000"},{"key":"jsn_footer_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_footer_container_sp_paddingleft","value":""},{"key":"jsn_footer_container_sp_paddingright","value":""},{"key":"jsn_footer_container_sp_paddingbottom","value":""},{"key":"jsn_footer_container_sp_paddingtop","value":""},{"key":"jsn_footer_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_footer_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_footer_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_footer_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_footer_module_tabContainer_ba_soildColor","value":"#000000"},{"key":"jsn_footer_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_footer_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_footer_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_footer_module_tabContainer_sh_shadowColor","value":""},{"key":"jsn_footer_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_footer_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_footer_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_footer_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_footer_module_tabContainer_sp_paddingleft","value":""},{"key":"jsn_footer_module_tabContainer_sp_paddingright","value":""},{"key":"jsn_footer_module_tabContainer_sp_paddingbottom","value":""},{"key":"jsn_footer_module_tabContainer_sp_paddingtop","value":""},{"value":""},{"value":""},{"key":"jsn_footer_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_footer_module_tabContent_title_fo_fontFace","value":"PT Sans"},{"key":"jsn_footer_module_tabContent_title_fo_fontSize","value":"16"},{"key":"jsn_footer_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_footer_module_tabContent_title_fo_fontColor","value":"#ffffff"},{"value":""},{"value":""},{"key":"jsn_footer_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_footer_module_tabContent_body_fo_fontFace","value":"PT Sans"},{"key":"jsn_footer_module_tabContent_body_fo_fontSize","value":"13"},{"key":"jsn_footer_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_footer_module_tabContent_body_fo_fontColor","value":"#ffffff"},{"key":"jsn_footer_module_tabContent_link_linkColor","value":"#eeeeee"}]',
                            'jsn_switcher':'[{"key":"jsn_switcher_container_bo_borderThickness","value":"1"},{"key":"jsn_switcher_container_bo_borderStyle","value":"solid"},{"key":"jsn_switcher_container_bo_borderColor","value":"#2e2e2e"},{"key":"jsn_switcher_container_ba_backgroundType","value":"Solid"},{"key":"jsn_switcher_container_ba_soildColor","value":"#121212"},{"key":"jsn_switcher_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_switcher_container_sp_paddingleft","value":""},{"key":"jsn_switcher_container_sp_paddingright","value":""},{"key":"jsn_switcher_container_sp_paddingbottom","value":"10"},{"key":"jsn_switcher_container_sp_paddingtop","value":"10"}]'
                        }
                    },
                    flat:{
                        title:"Flat",
                        thumbnail:"components/com_mobilize/assets/images/thumbnail/flat.jpg",
                        style:{
                            'jsn_menu':'[{"key":"jsn_menu_container_bo_borderThickness","value":"0"},{"key":"jsn_menu_container_bo_borderStyle","value":"dotted"},{"key":"jsn_menu_container_bo_borderColor","value":"#000000"},{"key":"jsn_menu_container_ba_backgroundType","value":"Solid"},{"key":"jsn_menu_container_ba_soildColor","value":"#000000"},{"key":"jsn_menu_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #a846a8 0%, #afb0ad 100%)"},{"key":"jsn_menu_container_ba_activeColor","value":"#262626"},{"key":"jsn_menu_container_ic_iconColor","value":"#ffffff"},{"key":"jsn_menu_sublevel1_bo_sublevel1_bo_borderThickness","value":"1"},{"key":"jsn_menu_sublevel1_bo_sublevel1_bo_borderStyle","value":"solid"},{"key":"jsn_menu_sublevel1_bo_sublevel1_bo_borderColor","value":"#333333"},{"key":"jsn_menu_sublevel1_ba_normalColor","value":"#262626"},{"key":"jsn_menu_sublevel1_ba_activeColor","value":"#000000"},{"value":""},{"value":""},{"key":"jsn_menu_sublevel1_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_menu_sublevel1_fo_fontFace","value":"Open Sans"},{"key":"jsn_menu_sublevel1_fo_fontSize","value":""},{"key":"jsn_menu_sublevel1_fo_fontStyle","value":"inherit"},{"key":"jsn_menu_sublevel1_fo_fontColor","value":"#ffffff"},{"key":"jsn_menu_sublevel2_ba_normalColor","value":"#1f1f1f"},{"value":""},{"value":""},{"key":"jsn_menu_sublevel2_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_menu_sublevel2_fo_fontFace","value":"Verdana"},{"key":"jsn_menu_sublevel2_fo_fontSize","value":""},{"key":"jsn_menu_sublevel2_fo_fontStyle","value":"inherit"},{"key":"jsn_menu_sublevel2_fo_fontColor","value":"#ffffff"}]',
                            'jsn_logo':'[{"key":"jsn_logo_container_bo_borderThickness","value":""},{"key":"jsn_logo_container_bo_borderStyle","value":"solid"},{"key":"jsn_logo_container_bo_borderColor","value":"#ffffff"},{"key":"jsn_logo_container_ba_backgroundType","value":"Solid"},{"key":"jsn_logo_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_logo_container_ba_gradientColor","value":"-moz-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_logo_container_sp_paddingleft","value":"10"},{"key":"jsn_logo_container_sp_paddingright","value":"10"},{"key":"jsn_logo_container_sp_paddingbottom","value":"10"},{"key":"jsn_logo_container_sp_paddingtop","value":"10"},{"key":"jsn_logo_content_alignment","value":"center"}]',
                            'jsn_mobile_tool':'[{"key":"jsn_mobile_tool_container_bo_borderThickness","value":""},{"key":"jsn_mobile_tool_container_bo_borderStyle","value":"solid"},{"key":"jsn_mobile_tool_container_bo_borderColor","value":"#ffffff"},{"key":"jsn_mobile_tool_container_ba_backgroundType","value":"Solid"},{"key":"jsn_mobile_tool_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_mobile_tool_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_mobile_tool_container_sp_paddingleft","value":""},{"key":"jsn_mobile_tool_container_sp_paddingright","value":""},{"key":"jsn_mobile_tool_container_sp_paddingbottom","value":""},{"key":"jsn_mobile_tool_container_sp_paddingtop","value":""},{"key":"jsn_mobile_tool_module_tabContainer_bo_borderThickness","value":"1"},{"key":"jsn_mobile_tool_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_mobile_tool_module_tabContainer_bo_borderColor","value":"#2b2b2b"},{"key":"jsn_mobile_tool_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_mobile_tool_module_tabContainer_ba_soildColor","value":"#ffffff"},{"key":"jsn_mobile_tool_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_mobile_tool_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_mobile_tool_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_mobile_tool_module_tabContainer_sh_shadowColor","value":"#ffffff"},{"key":"jsn_mobile_tool_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_mobile_tool_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_mobile_tool_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_mobile_tool_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_mobile_tool_module_tabContainer_sp_paddingleft","value":"15"},{"key":"jsn_mobile_tool_module_tabContainer_sp_paddingright","value":"15"},{"key":"jsn_mobile_tool_module_tabContainer_sp_paddingbottom","value":"10"},{"key":"jsn_mobile_tool_module_tabContainer_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontFace","value":"Lato"},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontSize","value":"16"},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontColor","value":"#000000"},{"value":""},{"value":""},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontFace","value":"Open Sans"},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontSize","value":""},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontColor","value":"#000000"},{"key":"jsn_mobile_tool_module_tabContent_link_linkColor","value":"#227bb3"}]',
                            'jsn_content_top':'[{"key":"jsn_content_top_container_bo_borderThickness","value":""},{"key":"jsn_content_top_container_bo_borderStyle","value":"solid"},{"key":"jsn_content_top_container_bo_borderColor","value":""},{"key":"jsn_content_top_container_ba_backgroundType","value":"Solid"},{"key":"jsn_content_top_container_ba_soildColor","value":"#5eb295"},{"key":"jsn_content_top_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_content_top_container_sp_paddingleft","value":""},{"key":"jsn_content_top_container_sp_paddingright","value":""},{"key":"jsn_content_top_container_sp_paddingbottom","value":""},{"key":"jsn_content_top_container_sp_paddingtop","value":""},{"key":"jsn_content_top_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_content_top_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_content_top_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_content_top_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_content_top_module_tabContainer_ba_soildColor","value":"#5eb295"},{"key":"jsn_content_top_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_content_top_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_content_top_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_content_top_module_tabContainer_sh_shadowColor","value":""},{"key":"jsn_content_top_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_content_top_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_content_top_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_content_top_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_content_top_module_tabContainer_sp_paddingleft","value":""},{"key":"jsn_content_top_module_tabContainer_sp_paddingright","value":""},{"key":"jsn_content_top_module_tabContainer_sp_paddingbottom","value":""},{"key":"jsn_content_top_module_tabContainer_sp_paddingtop","value":""},{"value":""},{"value":""},{"key":"jsn_content_top_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_content_top_module_tabContent_title_fo_fontFace","value":"Lato"},{"key":"jsn_content_top_module_tabContent_title_fo_fontSize","value":"16"},{"key":"jsn_content_top_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_content_top_module_tabContent_title_fo_fontColor","value":"#ffffff"},{"value":""},{"value":""},{"key":"jsn_content_top_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_content_top_module_tabContent_body_fo_fontFace","value":"Open Sans"},{"key":"jsn_content_top_module_tabContent_body_fo_fontSize","value":""},{"key":"jsn_content_top_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_content_top_module_tabContent_body_fo_fontColor","value":"#ffffff"},{"key":"jsn_content_top_module_tabContent_link_linkColor","value":"#c2fffb"}]',
                            'jsn_user_top':'[{"key":"jsn_user_top_container_bo_borderThickness","value":""},{"key":"jsn_user_top_container_bo_borderStyle","value":"solid"},{"key":"jsn_user_top_container_bo_borderColor","value":""},{"key":"jsn_user_top_container_ba_backgroundType","value":"Solid"},{"key":"jsn_user_top_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_user_top_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_user_top_container_sp_paddingleft","value":""},{"key":"jsn_user_top_container_sp_paddingright","value":""},{"key":"jsn_user_top_container_sp_paddingbottom","value":""},{"key":"jsn_user_top_container_sp_paddingtop","value":""},{"key":"jsn_user_top_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_user_top_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_user_top_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_user_top_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_user_top_module_tabContainer_ba_soildColor","value":""},{"key":"jsn_user_top_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_user_top_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_user_top_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_user_top_module_tabContainer_sh_shadowColor","value":""},{"key":"jsn_user_top_module_tabContainer_sp_marginleft","value":""},{"key":"jsn_user_top_module_tabContainer_sp_marginright","value":""},{"key":"jsn_user_top_module_tabContainer_sp_marginbottom","value":""},{"key":"jsn_user_top_module_tabContainer_sp_margintop","value":""},{"key":"jsn_user_top_module_tabContainer_sp_paddingleft","value":""},{"key":"jsn_user_top_module_tabContainer_sp_paddingright","value":""},{"key":"jsn_user_top_module_tabContainer_sp_paddingbottom","value":""},{"key":"jsn_user_top_module_tabContainer_sp_paddingtop","value":""},{"value":""},{"value":""},{"key":"jsn_user_top_module_tabContent_title_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_user_top_module_tabContent_title_fo_fontFace","value":"Verdana"},{"key":"jsn_user_top_module_tabContent_title_fo_fontSize","value":"16"},{"key":"jsn_user_top_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_user_top_module_tabContent_title_fo_fontColor","value":"#000000"},{"value":""},{"value":""},{"key":"jsn_user_top_module_tabContent_body_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_user_top_module_tabContent_body_fo_fontFace","value":"Verdana"},{"key":"jsn_user_top_module_tabContent_body_fo_fontSize","value":""},{"key":"jsn_user_top_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_user_top_module_tabContent_body_fo_fontColor","value":"#000000"},{"key":"jsn_user_top_module_tabContent_link_linkColor","value":""}]',
                            'jsn_mainbody':'[{"key":"jsn_mainbody_container_bo_borderThickness","value":""},{"key":"jsn_mainbody_container_bo_borderStyle","value":"solid"},{"key":"jsn_mainbody_container_bo_borderColor","value":"#ffffff"},{"key":"jsn_mainbody_container_ba_backgroundType","value":"Solid"},{"key":"jsn_mainbody_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_mainbody_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_mainbody_container_sh_shadowSpread","value":"0"},{"key":"jsn_mainbody_container_sh_shadowColor","value":"#ffffff"},{"key":"jsn_mainbody_container_bo_roundedCornerRadius","value":"0"},{"key":"jsn_mainbody_container_sp_paddingleft","value":"10"},{"key":"jsn_mainbody_container_sp_paddingright","value":"10"},{"key":"jsn_mainbody_container_sp_paddingbottom","value":"10"},{"key":"jsn_mainbody_container_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_mainbody_content_title_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_mainbody_content_title_fo_fontFace","value":"Verdana"},{"key":"jsn_mainbody_content_title_fo_fontSize","value":"20"},{"key":"jsn_mainbody_content_title_fo_fontStyle","value":"inherit"},{"key":"jsn_mainbody_content_title_fo_fontColor","value":"#000000"},{"value":""},{"value":""},{"key":"jsn_mainbody_content_body_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_mainbody_content_body_fo_fontFace","value":"Verdana"},{"key":"jsn_mainbody_content_body_fo_fontSize","value":""},{"key":"jsn_mainbody_content_body_fo_fontStyle","value":"inherit"},{"key":"jsn_mainbody_content_body_fo_fontColor","value":"#000000"},{"key":"jsn_mainbody_content_link_linkColor","value":""}]',
                            'jsn_user_bottom':'[{"key":"jsn_user_bottom_container_bo_borderThickness","value":""},{"key":"jsn_user_bottom_container_bo_borderStyle","value":"solid"},{"key":"jsn_user_bottom_container_bo_borderColor","value":""},{"key":"jsn_user_bottom_container_ba_backgroundType","value":"Solid"},{"key":"jsn_user_bottom_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_user_bottom_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_user_bottom_container_sp_paddingleft","value":""},{"key":"jsn_user_bottom_container_sp_paddingright","value":""},{"key":"jsn_user_bottom_container_sp_paddingbottom","value":""},{"key":"jsn_user_bottom_container_sp_paddingtop","value":""},{"key":"jsn_user_bottom_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_user_bottom_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_user_bottom_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_user_bottom_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_user_bottom_module_tabContainer_ba_soildColor","value":"#3d4651"},{"key":"jsn_user_bottom_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_user_bottom_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_user_bottom_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_user_bottom_module_tabContainer_sh_shadowColor","value":""},{"key":"jsn_user_bottom_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_user_bottom_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_user_bottom_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_user_bottom_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_user_bottom_module_tabContainer_sp_paddingleft","value":"15"},{"key":"jsn_user_bottom_module_tabContainer_sp_paddingright","value":"15"},{"key":"jsn_user_bottom_module_tabContainer_sp_paddingbottom","value":"10"},{"key":"jsn_user_bottom_module_tabContainer_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontFace","value":"Lato"},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontSize","value":"16"},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontColor","value":"#ffffff"},{"value":""},{"value":""},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontFace","value":"Open Sans"},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontSize","value":""},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontColor","value":"#ffffff"},{"key":"jsn_user_bottom_module_tabContent_link_linkColor","value":"#c6e0f2"}]',
                            'jsn_content_bottom':'[{"key":"jsn_content_bottom_container_bo_borderThickness","value":""},{"key":"jsn_content_bottom_container_bo_borderStyle","value":"solid"},{"key":"jsn_content_bottom_container_bo_borderColor","value":""},{"key":"jsn_content_bottom_container_ba_backgroundType","value":"Solid"},{"key":"jsn_content_bottom_container_ba_soildColor","value":"#cd471a"},{"key":"jsn_content_bottom_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_content_bottom_container_sp_paddingleft","value":""},{"key":"jsn_content_bottom_container_sp_paddingright","value":""},{"key":"jsn_content_bottom_container_sp_paddingbottom","value":""},{"key":"jsn_content_bottom_container_sp_paddingtop","value":""},{"key":"jsn_content_bottom_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_content_bottom_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_content_bottom_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_content_bottom_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_content_bottom_module_tabContainer_ba_soildColor","value":"#cd471a"},{"key":"jsn_content_bottom_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_content_bottom_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_content_bottom_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_content_bottom_module_tabContainer_sh_shadowColor","value":""},{"key":"jsn_content_bottom_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_content_bottom_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_content_bottom_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_content_bottom_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_content_bottom_module_tabContainer_sp_paddingleft","value":""},{"key":"jsn_content_bottom_module_tabContainer_sp_paddingright","value":""},{"key":"jsn_content_bottom_module_tabContainer_sp_paddingbottom","value":""},{"key":"jsn_content_bottom_module_tabContainer_sp_paddingtop","value":""},{"value":""},{"value":""},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontFace","value":"Lato"},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontSize","value":"16"},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontColor","value":"#ffffff"},{"value":""},{"value":""},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontFaceType","value":"google fonts"},{"value":""},{"value":""},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontFace","value":"Open Sans"},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontSize","value":""},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontColor","value":"#ffffff"},{"key":"jsn_content_bottom_module_tabContent_link_linkColor","value":"#f7c8be"}]',
                            'jsn_footer':'[{"key":"jsn_footer_container_bo_borderThickness","value":"1"},{"key":"jsn_footer_container_bo_borderStyle","value":"solid"},{"key":"jsn_footer_container_bo_borderColor","value":"#000000"},{"key":"jsn_footer_container_ba_backgroundType","value":"Solid"},{"key":"jsn_footer_container_ba_soildColor","value":"#303030"},{"key":"jsn_footer_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_footer_container_sp_paddingleft","value":""},{"key":"jsn_footer_container_sp_paddingright","value":""},{"key":"jsn_footer_container_sp_paddingbottom","value":""},{"key":"jsn_footer_container_sp_paddingtop","value":""},{"key":"jsn_footer_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_footer_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_footer_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_footer_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_footer_module_tabContainer_ba_soildColor","value":""},{"key":"jsn_footer_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_footer_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_footer_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_footer_module_tabContainer_sh_shadowColor","value":""},{"key":"jsn_footer_module_tabContainer_sp_marginleft","value":""},{"key":"jsn_footer_module_tabContainer_sp_marginright","value":""},{"key":"jsn_footer_module_tabContainer_sp_marginbottom","value":""},{"key":"jsn_footer_module_tabContainer_sp_margintop","value":""},{"key":"jsn_footer_module_tabContainer_sp_paddingleft","value":""},{"key":"jsn_footer_module_tabContainer_sp_paddingright","value":""},{"key":"jsn_footer_module_tabContainer_sp_paddingbottom","value":""},{"key":"jsn_footer_module_tabContainer_sp_paddingtop","value":""},{"value":""},{"value":""},{"key":"jsn_footer_module_tabContent_title_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_footer_module_tabContent_title_fo_fontFace","value":"Verdana"},{"key":"jsn_footer_module_tabContent_title_fo_fontSize","value":"16"},{"key":"jsn_footer_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_footer_module_tabContent_title_fo_fontColor","value":"#ffffff"},{"value":""},{"value":""},{"key":"jsn_footer_module_tabContent_body_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_footer_module_tabContent_body_fo_fontFace","value":"Verdana"},{"key":"jsn_footer_module_tabContent_body_fo_fontSize","value":"11"},{"key":"jsn_footer_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_footer_module_tabContent_body_fo_fontColor","value":"#ffffff"},{"key":"jsn_footer_module_tabContent_link_linkColor","value":""}]',
                            'jsn_switcher':'[{"key":"jsn_switcher_container_bo_borderThickness","value":"0"},{"key":"jsn_switcher_container_bo_borderStyle","value":"solid"},{"key":"jsn_switcher_container_bo_borderColor","value":"#1f1f1f"},{"key":"jsn_switcher_container_ba_backgroundType","value":"Solid"},{"key":"jsn_switcher_container_ba_soildColor","value":"#000000"},{"key":"jsn_switcher_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_switcher_container_sp_paddingleft","value":""},{"key":"jsn_switcher_container_sp_paddingright","value":""},{"key":"jsn_switcher_container_sp_paddingbottom","value":"10"},{"key":"jsn_switcher_container_sp_paddingtop","value":"10"}]'
                        }

                    },
                    skeuomorphism:{
                        title:"Skeuomorphism",
                        thumbnail:"components/com_mobilize/assets/images/thumbnail/skeu.jpg",
                        style:{
                            'jsn_menu':'[{"key":"jsn_menu_container_bo_borderThickness","value":"1"},{"key":"jsn_menu_container_bo_borderStyle","value":"solid"},{"key":"jsn_menu_container_bo_borderColor","value":"#bfbfbf"},{"key":"jsn_menu_container_ba_backgroundType","value":"Gradient"},{"key":"jsn_menu_container_ba_soildColor","value":"#121212"},{"key":"jsn_menu_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #dedede 100%)"},{"key":"jsn_menu_container_ba_activeColor","value":"#d6d6d6"},{"key":"jsn_menu_container_ic_iconColor","value":"#1c1c1c"},{"key":"jsn_menu_sublevel1_bo_sublevel1_bo_borderThickness","value":"1"},{"key":"jsn_menu_sublevel1_bo_sublevel1_bo_borderStyle","value":"solid"},{"key":"jsn_menu_sublevel1_bo_sublevel1_bo_borderColor","value":"#b0b0b0"},{"key":"jsn_menu_sublevel1_ba_normalColor","value":"#ffffff"},{"key":"jsn_menu_sublevel1_ba_activeColor","value":"#e0e0e0"},{"value":""},{"value":""},{"key":"jsn_menu_sublevel1_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_menu_sublevel1_fo_fontFace","value":"Verdana"},{"key":"jsn_menu_sublevel1_fo_fontSize","value":""},{"key":"jsn_menu_sublevel1_fo_fontStyle","value":"inherit"},{"key":"jsn_menu_sublevel1_fo_fontColor","value":"#333333"},{"key":"jsn_menu_sublevel2_ba_normalColor","value":"#ffffff"},{"value":""},{"value":""},{"key":"jsn_menu_sublevel2_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_menu_sublevel2_fo_fontFace","value":"Verdana"},{"key":"jsn_menu_sublevel2_fo_fontSize","value":""},{"key":"jsn_menu_sublevel2_fo_fontStyle","value":"inherit"},{"key":"jsn_menu_sublevel2_fo_fontColor","value":"#333333"}]',
                            'jsn_logo':'[{"key":"jsn_logo_container_bo_borderThickness","value":""},{"key":"jsn_logo_container_bo_borderStyle","value":"solid"},{"key":"jsn_logo_container_bo_borderColor","value":"#ffffff"},{"key":"jsn_logo_container_ba_backgroundType","value":"Solid"},{"key":"jsn_logo_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_logo_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_logo_container_sp_paddingleft","value":"10"},{"key":"jsn_logo_container_sp_paddingright","value":"10"},{"key":"jsn_logo_container_sp_paddingbottom","value":"10"},{"key":"jsn_logo_container_sp_paddingtop","value":"10"},{"key":"jsn_logo_content_alignment","value":"center"}]',
                            'jsn_mobile_tool':'[{"key":"jsn_mobile_tool_container_bo_borderThickness","value":"0"},{"key":"jsn_mobile_tool_container_bo_borderStyle","value":"solid"},{"key":"jsn_mobile_tool_container_bo_borderColor","value":"#ffffff"},{"key":"jsn_mobile_tool_container_ba_backgroundType","value":"Solid"},{"key":"jsn_mobile_tool_container_ba_soildColor","value":"#757575"},{"key":"jsn_mobile_tool_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_mobile_tool_container_sp_paddingleft","value":"20"},{"key":"jsn_mobile_tool_container_sp_paddingright","value":"20"},{"key":"jsn_mobile_tool_container_sp_paddingbottom","value":"10"},{"key":"jsn_mobile_tool_container_sp_paddingtop","value":"10"},{"key":"jsn_mobile_tool_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_mobile_tool_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_mobile_tool_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_mobile_tool_module_tabContainer_ba_backgroundType","value":"Gradient"},{"key":"jsn_mobile_tool_module_tabContainer_ba_soildColor","value":"#ed3447"},{"key":"jsn_mobile_tool_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ededed 0%, #ffffff 98%, #dedede 98%, #ffffff 100%)"},{"key":"jsn_mobile_tool_module_tabContainer_bo_roundedCornerRadius","value":"4"},{"key":"jsn_mobile_tool_module_tabContainer_sh_shadowSpread","value":"2"},{"key":"jsn_mobile_tool_module_tabContainer_sh_shadowColor","value":"#1f1f1f"},{"key":"jsn_mobile_tool_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_mobile_tool_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_mobile_tool_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_mobile_tool_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_mobile_tool_module_tabContainer_sp_paddingleft","value":"15"},{"key":"jsn_mobile_tool_module_tabContainer_sp_paddingright","value":"15"},{"key":"jsn_mobile_tool_module_tabContainer_sp_paddingbottom","value":"10"},{"key":"jsn_mobile_tool_module_tabContainer_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontFace","value":"Verdana"},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontSize","value":"16"},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_mobile_tool_module_tabContent_title_fo_fontColor","value":"#333333"},{"value":""},{"value":""},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontFace","value":"Verdana"},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontSize","value":""},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_mobile_tool_module_tabContent_body_fo_fontColor","value":"#333333"},{"key":"jsn_mobile_tool_module_tabContent_link_linkColor","value":"#2465a6"}]',
                            'jsn_content_top':'[{"key":"jsn_content_top_container_bo_borderThickness","value":""},{"key":"jsn_content_top_container_bo_borderStyle","value":"solid"},{"key":"jsn_content_top_container_bo_borderColor","value":""},{"key":"jsn_content_top_container_ba_backgroundType","value":"Solid"},{"key":"jsn_content_top_container_ba_soildColor","value":"#757575"},{"key":"jsn_content_top_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_content_top_container_sp_paddingleft","value":"20"},{"key":"jsn_content_top_container_sp_paddingright","value":"20"},{"key":"jsn_content_top_container_sp_paddingbottom","value":"10"},{"key":"jsn_content_top_container_sp_paddingtop","value":"10"},{"key":"jsn_content_top_module_tabContainer_bo_borderThickness","value":"0"},{"key":"jsn_content_top_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_content_top_module_tabContainer_bo_borderColor","value":"#292929"},{"key":"jsn_content_top_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_content_top_module_tabContainer_ba_soildColor","value":"#545454"},{"key":"jsn_content_top_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_content_top_module_tabContainer_bo_roundedCornerRadius","value":"4"},{"key":"jsn_content_top_module_tabContainer_sh_shadowSpread","value":"1"},{"key":"jsn_content_top_module_tabContainer_sh_shadowColor","value":"#919191"},{"key":"jsn_content_top_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_content_top_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_content_top_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_content_top_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_content_top_module_tabContainer_sp_paddingleft","value":"15"},{"key":"jsn_content_top_module_tabContainer_sp_paddingright","value":"15"},{"key":"jsn_content_top_module_tabContainer_sp_paddingbottom","value":"10"},{"key":"jsn_content_top_module_tabContainer_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_content_top_module_tabContent_title_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_content_top_module_tabContent_title_fo_fontFace","value":"Verdana"},{"key":"jsn_content_top_module_tabContent_title_fo_fontSize","value":"16"},{"key":"jsn_content_top_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_content_top_module_tabContent_title_fo_fontColor","value":"#ffffff"},{"value":""},{"value":""},{"key":"jsn_content_top_module_tabContent_body_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_content_top_module_tabContent_body_fo_fontFace","value":"Verdana"},{"key":"jsn_content_top_module_tabContent_body_fo_fontSize","value":""},{"key":"jsn_content_top_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_content_top_module_tabContent_body_fo_fontColor","value":"#ffffff"},{"key":"jsn_content_top_module_tabContent_link_linkColor","value":"#dedede"}]',
                            'jsn_user_top':'[{"key":"jsn_user_top_container_bo_borderThickness","value":""},{"key":"jsn_user_top_container_bo_borderStyle","value":"solid"},{"key":"jsn_user_top_container_bo_borderColor","value":""},{"key":"jsn_user_top_container_ba_backgroundType","value":"Solid"},{"key":"jsn_user_top_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_user_top_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_user_top_container_sp_paddingleft","value":"20"},{"key":"jsn_user_top_container_sp_paddingright","value":"20"},{"key":"jsn_user_top_container_sp_paddingbottom","value":"10"},{"key":"jsn_user_top_container_sp_paddingtop","value":"10"},{"key":"jsn_user_top_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_user_top_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_user_top_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_user_top_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_user_top_module_tabContainer_ba_soildColor","value":"#ffffff"},{"key":"jsn_user_top_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_user_top_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_user_top_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_user_top_module_tabContainer_sh_shadowColor","value":""},{"key":"jsn_user_top_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_user_top_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_user_top_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_user_top_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_user_top_module_tabContainer_sp_paddingleft","value":""},{"key":"jsn_user_top_module_tabContainer_sp_paddingright","value":""},{"key":"jsn_user_top_module_tabContainer_sp_paddingbottom","value":""},{"key":"jsn_user_top_module_tabContainer_sp_paddingtop","value":""},{"value":""},{"value":""},{"key":"jsn_user_top_module_tabContent_title_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_user_top_module_tabContent_title_fo_fontFace","value":"Verdana"},{"key":"jsn_user_top_module_tabContent_title_fo_fontSize","value":"16"},{"key":"jsn_user_top_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_user_top_module_tabContent_title_fo_fontColor","value":"#333333"},{"value":""},{"value":""},{"key":"jsn_user_top_module_tabContent_body_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_user_top_module_tabContent_body_fo_fontFace","value":"Verdana"},{"key":"jsn_user_top_module_tabContent_body_fo_fontSize","value":""},{"key":"jsn_user_top_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_user_top_module_tabContent_body_fo_fontColor","value":"#333333"},{"key":"jsn_user_top_module_tabContent_link_linkColor","value":"#236fad"}]',
                            'jsn_mainbody':'[{"key":"jsn_mainbody_container_bo_borderThickness","value":""},{"key":"jsn_mainbody_container_bo_borderStyle","value":"dotted"},{"key":"jsn_mainbody_container_bo_borderColor","value":"#ffffff"},{"key":"jsn_mainbody_container_ba_backgroundType","value":"Solid"},{"key":"jsn_mainbody_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_mainbody_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_mainbody_container_sh_shadowSpread","value":""},{"key":"jsn_mainbody_container_sh_shadowColor","value":"#ffffff"},{"key":"jsn_mainbody_container_bo_roundedCornerRadius","value":""},{"key":"jsn_mainbody_container_sp_paddingleft","value":"20"},{"key":"jsn_mainbody_container_sp_paddingright","value":"20"},{"key":"jsn_mainbody_container_sp_paddingbottom","value":"10"},{"key":"jsn_mainbody_container_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_mainbody_content_title_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_mainbody_content_title_fo_fontFace","value":"Verdana"},{"key":"jsn_mainbody_content_title_fo_fontSize","value":"20"},{"key":"jsn_mainbody_content_title_fo_fontStyle","value":"inherit"},{"key":"jsn_mainbody_content_title_fo_fontColor","value":"#000000"},{"value":""},{"value":""},{"key":"jsn_mainbody_content_body_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_mainbody_content_body_fo_fontFace","value":"Verdana"},{"key":"jsn_mainbody_content_body_fo_fontSize","value":""},{"key":"jsn_mainbody_content_body_fo_fontStyle","value":"inherit"},{"key":"jsn_mainbody_content_body_fo_fontColor","value":"#000000"},{"key":"jsn_mainbody_content_link_linkColor","value":""}]',
                            'jsn_user_bottom':'[{"key":"jsn_user_bottom_container_bo_borderThickness","value":""},{"key":"jsn_user_bottom_container_bo_borderStyle","value":"solid"},{"key":"jsn_user_bottom_container_bo_borderColor","value":""},{"key":"jsn_user_bottom_container_ba_backgroundType","value":"Solid"},{"key":"jsn_user_bottom_container_ba_soildColor","value":"#ffffff"},{"key":"jsn_user_bottom_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_user_bottom_container_sp_paddingleft","value":"20"},{"key":"jsn_user_bottom_container_sp_paddingright","value":"20"},{"key":"jsn_user_bottom_container_sp_paddingbottom","value":"10"},{"key":"jsn_user_bottom_container_sp_paddingtop","value":"10"},{"key":"jsn_user_bottom_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_user_bottom_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_user_bottom_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_user_bottom_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_user_bottom_module_tabContainer_ba_soildColor","value":"#ffffff"},{"key":"jsn_user_bottom_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_user_bottom_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_user_bottom_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_user_bottom_module_tabContainer_sh_shadowColor","value":""},{"key":"jsn_user_bottom_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_user_bottom_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_user_bottom_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_user_bottom_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_user_bottom_module_tabContainer_sp_paddingleft","value":""},{"key":"jsn_user_bottom_module_tabContainer_sp_paddingright","value":""},{"key":"jsn_user_bottom_module_tabContainer_sp_paddingbottom","value":""},{"key":"jsn_user_bottom_module_tabContainer_sp_paddingtop","value":""},{"value":""},{"value":""},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontFace","value":"Verdana"},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontSize","value":"16"},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_user_bottom_module_tabContent_title_fo_fontColor","value":"#333333"},{"value":""},{"value":""},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontFace","value":"Verdana"},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontSize","value":""},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_user_bottom_module_tabContent_body_fo_fontColor","value":"#333333"},{"key":"jsn_user_bottom_module_tabContent_link_linkColor","value":"#216bb5"}]',
                            'jsn_content_bottom':'[{"key":"jsn_content_bottom_container_bo_borderThickness","value":""},{"key":"jsn_content_bottom_container_bo_borderStyle","value":"solid"},{"key":"jsn_content_bottom_container_bo_borderColor","value":""},{"key":"jsn_content_bottom_container_ba_backgroundType","value":"Solid"},{"key":"jsn_content_bottom_container_ba_soildColor","value":"#757575"},{"key":"jsn_content_bottom_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_content_bottom_container_sp_paddingleft","value":"20"},{"key":"jsn_content_bottom_container_sp_paddingright","value":"20"},{"key":"jsn_content_bottom_container_sp_paddingbottom","value":"10"},{"key":"jsn_content_bottom_container_sp_paddingtop","value":"10"},{"key":"jsn_content_bottom_module_tabContainer_bo_borderThickness","value":"1"},{"key":"jsn_content_bottom_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_content_bottom_module_tabContainer_bo_borderColor","value":"#ffffff"},{"key":"jsn_content_bottom_module_tabContainer_ba_backgroundType","value":"Gradient"},{"key":"jsn_content_bottom_module_tabContainer_ba_soildColor","value":"#bdbdbd"},{"key":"jsn_content_bottom_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ededed 1%, #ffffff 99%, #c2c2c2 99%, #ffffff 100%)"},{"key":"jsn_content_bottom_module_tabContainer_bo_roundedCornerRadius","value":"4"},{"key":"jsn_content_bottom_module_tabContainer_sh_shadowSpread","value":"1"},{"key":"jsn_content_bottom_module_tabContainer_sh_shadowColor","value":"#1c1c1c"},{"key":"jsn_content_bottom_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_content_bottom_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_content_bottom_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_content_bottom_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_content_bottom_module_tabContainer_sp_paddingleft","value":"15"},{"key":"jsn_content_bottom_module_tabContainer_sp_paddingright","value":"15"},{"key":"jsn_content_bottom_module_tabContainer_sp_paddingbottom","value":"10"},{"key":"jsn_content_bottom_module_tabContainer_sp_paddingtop","value":"10"},{"value":""},{"value":""},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontFace","value":"Verdana"},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontSize","value":"16"},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_content_bottom_module_tabContent_title_fo_fontColor","value":"#333333"},{"value":""},{"value":""},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontFace","value":"Verdana"},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontSize","value":""},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_content_bottom_module_tabContent_body_fo_fontColor","value":"#333333"},{"key":"jsn_content_bottom_module_tabContent_link_linkColor","value":"#206fb0"}]',
                            'jsn_footer':'[{"key":"jsn_footer_container_bo_borderThickness","value":""},{"key":"jsn_footer_container_bo_borderStyle","value":"solid"},{"key":"jsn_footer_container_bo_borderColor","value":""},{"key":"jsn_footer_container_ba_backgroundType","value":"Solid"},{"key":"jsn_footer_container_ba_soildColor","value":"#000000"},{"key":"jsn_footer_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_footer_container_sp_paddingleft","value":"20"},{"key":"jsn_footer_container_sp_paddingright","value":"20"},{"key":"jsn_footer_container_sp_paddingbottom","value":"10"},{"key":"jsn_footer_container_sp_paddingtop","value":"10"},{"key":"jsn_footer_module_tabContainer_bo_borderThickness","value":""},{"key":"jsn_footer_module_tabContainer_bo_borderStyle","value":"solid"},{"key":"jsn_footer_module_tabContainer_bo_borderColor","value":""},{"key":"jsn_footer_module_tabContainer_ba_backgroundType","value":"Solid"},{"key":"jsn_footer_module_tabContainer_ba_soildColor","value":"#000000"},{"key":"jsn_footer_module_tabContainer_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_footer_module_tabContainer_bo_roundedCornerRadius","value":""},{"key":"jsn_footer_module_tabContainer_sh_shadowSpread","value":""},{"key":"jsn_footer_module_tabContainer_sh_shadowColor","value":""},{"key":"jsn_footer_module_tabContainer_sp_marginleft","value":"5"},{"key":"jsn_footer_module_tabContainer_sp_marginright","value":"5"},{"key":"jsn_footer_module_tabContainer_sp_marginbottom","value":"15"},{"key":"jsn_footer_module_tabContainer_sp_margintop","value":"15"},{"key":"jsn_footer_module_tabContainer_sp_paddingleft","value":""},{"key":"jsn_footer_module_tabContainer_sp_paddingright","value":""},{"key":"jsn_footer_module_tabContainer_sp_paddingbottom","value":""},{"key":"jsn_footer_module_tabContainer_sp_paddingtop","value":""},{"value":""},{"value":""},{"key":"jsn_footer_module_tabContent_title_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_footer_module_tabContent_title_fo_fontFace","value":"Verdana"},{"key":"jsn_footer_module_tabContent_title_fo_fontSize","value":"16"},{"key":"jsn_footer_module_tabContent_title_fo_fontStyle","value":"inherit"},{"key":"jsn_footer_module_tabContent_title_fo_fontColor","value":"#ffffff"},{"value":""},{"value":""},{"key":"jsn_footer_module_tabContent_body_fo_fontFaceType","value":"standard fonts"},{"value":""},{"value":""},{"key":"jsn_footer_module_tabContent_body_fo_fontFace","value":"Verdana"},{"key":"jsn_footer_module_tabContent_body_fo_fontSize","value":""},{"key":"jsn_footer_module_tabContent_body_fo_fontStyle","value":"inherit"},{"key":"jsn_footer_module_tabContent_body_fo_fontColor","value":"#ffffff"},{"key":"jsn_footer_module_tabContent_link_linkColor","value":"#2b6cb5"}]',
                            'jsn_switcher':'[{"key":"jsn_switcher_container_bo_borderThickness","value":"1"},{"key":"jsn_switcher_container_bo_borderStyle","value":"solid"},{"key":"jsn_switcher_container_bo_borderColor","value":"#303030"},{"key":"jsn_switcher_container_ba_backgroundType","value":"Solid"},{"key":"jsn_switcher_container_ba_soildColor","value":"#000000"},{"key":"jsn_switcher_container_ba_gradientColor","value":"-webkit-linear-gradient(-90deg, #ffffff 0%, #ffffff 100%)"},{"key":"jsn_switcher_container_sp_paddingleft","value":"10"},{"key":"jsn_switcher_container_sp_paddingright","value":"10"},{"key":"jsn_switcher_container_sp_paddingbottom","value":"10"},{"key":"jsn_switcher_container_sp_paddingtop","value":"10"}]'
                        }
                    }
                }
                return style;
            }
        }
        return JSNMobilizeStyle;
    })