<?php
/**
 * @version     $Id$
 * @package     JSN_Mobilize
 * @subpackage  SystemPlugin
 * @author      JoomlaShine Team <support@joomlashine.com>
 * @copyright   Copyright (C) 2012 JoomlaShine.com. All Rights Reserved.
 * @license     GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.joomlashine.com
 * Technical Support:  Feedback - http://www.joomlashine.com/contact-us/get-support.html
 */
// Check to ensure this file is included in Joomla!
defined ( '_JEXEC' ) or die ( 'Restricted access' );
$min = VmConfig::get('asks_minimum_comment_length', 50);
$max = VmConfig::get('asks_maximum_comment_length', 2000) ;
vmJsApi::JvalideForm();
$document = JFactory::getDocument();
$document->addScriptDeclaration('
	jQuery(function($){
			$("#askform").validationEngine("attach");
			$("#comment").keyup( function () {
				var result = $(this).val();
					$("#counter").val( result.length );
			});
	});
');
/* Let's see if we found the product */
if (empty ( $this->product )) {
	echo JText::_ ( 'COM_VIRTUEMART_PRODUCT_NOT_FOUND' );
	echo '<br /><br />  ' . $this->continue_link_html;
} else { ?>

<div class="ask-a-question-view">
	<h1><?php echo JText::_('COM_VIRTUEMART_PRODUCT_ASK_QUESTION')  ?></h1>

	<div class="product-summary">
		<div class="width70 floatleft">
			<h2><?php echo $this->product->product_name ?></h2>

			<?php // Product Short Description
			if (!empty($this->product->product_s_desc)) { ?>
				<div class="short-description">
					<?php echo $this->product->product_s_desc ?>
				</div>
			<?php } // Product Short Description END ?>

		</div>

		<div class="width30 floatleft right">
			<?php // Product Image
			echo $this->product->images[0]->displayMediaThumb('class="product-image"',false); ?>
		</div>

	<div class="clear"></div>
	</div>

	<div class="form-field">

		<form method="post" class="form-validate" action="<?php echo JRoute::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id='.$this->product->virtuemart_product_id.'&virtuemart_category_id='.$this->product->virtuemart_category_id.'&tmpl=component') ; ?>" name="askform" id="askform">

			<p><label><?php echo JText::_('COM_VIRTUEMART_USER_FORM_NAME')  ?> : <input type="text" class="validate[required,minSize[4],maxSize[64]]" value="<?php echo $this->user->name ?>" name="name" id="name" size="30"  validation="required name"/></label></p>
	
			<p><label><?php echo JText::_('COM_VIRTUEMART_USER_FORM_EMAIL')  ?> : <input type="text" class="validate[required,custom[email]]" value="<?php echo $this->user->email ?>" name="email" id="email" size="30"  validation="required email"/></label></p>

			<label>
				<?php
				$ask_comment = JText::sprintf('COM_VIRTUEMART_ASK_COMMENT', $min, $max);
				echo $ask_comment;
				?>
				<br />
				<textarea title="<?php echo $ask_comment ?>" class="validate[required,minSize[<?php echo $min ?>],maxSize[<?php echo $max ?>]] field" id="comment" name="comment" rows="10"></textarea>
			</label>
			<div class="submit">
				<input class="highlight-button" type="submit" name="submit_ask" title="<?php echo JText::_('COM_VIRTUEMART_ASK_SUBMIT')  ?>" value="<?php echo JText::_('COM_VIRTUEMART_ASK_SUBMIT')  ?>" />

				<div class="width50 floatright right paddingtop">
					<?php echo JText::_('COM_VIRTUEMART_ASK_COUNT')  ?>
					<input type="text" value="0" size="4" class="counter" id="counter" name="counter" maxlength="4" readonly="readonly" />
				</div>
			</div>

			<input type="hidden" name="virtuemart_product_id" value="<?php echo JRequest::getInt('virtuemart_product_id',0); ?>" />
			<input type="hidden" name="tmpl" value="component" />
			<input type="hidden" name="view" value="productdetails" />
			<input type="hidden" name="option" value="com_virtuemart" />
			<input type="hidden" name="virtuemart_category_id" value="<?php echo JRequest::getInt('virtuemart_category_id'); ?>" />
			<input type="hidden" name="task" value="mailAskquestion" />
			<?php echo JHTML::_( 'form.token' ); ?>
		</form>

	</div>

</div>

<?php } ?>
<style type="text/css">
.ask-a-question-view {
	padding: 20px;
}
.ask-a-question-view .product-summary {
	margin-top: 15px;
}
.ask-a-question-view .product-summary img.product-image {
	border: 1px solid #ccc;
}
.ask-a-question-view input {
	border: 1px solid #ccc;
}
input.highlight-button {
	background-color: #FEFEFE;
    color: #678B99;
    font-weight: bold;
    padding: 8px 8px 7px;
	background-image: -ms-linear-gradient(top, #FEFEFE 0%, #EAEFF1 100%);
	background-image: -moz-linear-gradient(top, #FEFEFE 0%, #EAEFF1 100%);
	background-image: -o-linear-gradient(top, #FEFEFE 0%, #EAEFF1 100%);
	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #FEFEFE), color-stop(1, #EAEFF1));
	background-image: -webkit-linear-gradient(top, #FEFEFE 0%, #EAEFF1 100%);
	background-image: linear-gradient(to bottom, #FEFEFE 0%, #EAEFF1 100%);
	border-top: 1px solid #d6dfe2;
	border-left: 1px solid #d7e0e3;
	border-right: 1px solid #d7e0e3;
	border-bottom: 1px solid #d7e0e3; 
	-moz-border-radius: 15px;
	-webkit-border-radius: 15px;
	border-radius: 15px;
	-ms-filter:"progid:DXImageTransform.Microsoft.gradient(startColorstr=#ffffffff,endColorstr=#ffeeeeee,GradientType=0)";
	filter:progid:DXImageTransform.Microsoft.gradient(startColorstr=#ffffffff,endColorstr=#ffeeeeee,GradientType=0);
}
input.highlight-button {
	color: #678B99;
}
.submit {
	margin-top: 10px;
}
</style>